/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.wrapper;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.List;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.wrapper.CertificateWrapper;

public class KeyStoreWrapper {
    private final KeyStore keyStore;
    private final String alias;
    private final String password;
    private final List<String> aliases;

    public PrivateKey getPrivateKey() {
        try {
            return (PrivateKey)this.getKeyStore().getKey(this.getAlias(), this.getPassword().toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            BundleLog.LOG.error("Key reading error: Cannot extract private key.", e);
            throw new RuntimeException("Key reading error: Cannot extract private key.", e);
        }
    }

    public CertificateWrapper getCertificate() {
        try {
            return new CertificateWrapper((X509Certificate)this.getKeyStore().getCertificate(this.getAlias()));
        }
        catch (KeyStoreException e) {
            BundleLog.LOG.error("Key reading error: Cannot extract certificate.", e);
            throw new RuntimeException("Key reading error: Cannot extract certificate.", e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public KeyStoreWrapper(KeyStore keyStore, String alias, String password, List<String> aliases) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.password = password;
        this.aliases = aliases;
    }
}

