/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.wrapper;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.smartcardio.CardException;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.dto.request.DocumentSignatureRequest;
import kz.devart.bundle.util.KeyUtil;
import kz.devart.bundle.wrapper.KeyStoreWrapper;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KeyStoreEntry;

public class KalkanWrapper {
    private KalkanProvider kalkanProvider = new KalkanProvider();

    public KeyStoreWrapper read(String storageName, String cont, String password, String choosenalias) throws RuntimeException {
        KeyStore store;
        Storage storage = Storage.get((String)storageName);
        try {
            String container = storage.isToken() ? this.getContainer(storageName) : cont;
            store = KeyStoreUtil.getKeyStore((Storage)storage, (String)container, (char[])password.toCharArray(), (Provider)new KalkanProvider());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException | CardException | KalkanException | ProviderUtilException e) {
            e.printStackTrace();
            throw new RuntimeException(KalkanWrapper.createMessageFromException((Exception)e));
        }
        List<String> aliases = KeyUtil.getAliases(store);
        String keyAlias = null;
        try {
            Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((KeyStore)store, (char[])password.toCharArray());
            for (Map.Entry entry : keyStoreEntries.entrySet()) {
                String alias = (String)entry.getKey();
                KeyStoreEntry v = (KeyStoreEntry)entry.getValue();
                X509Certificate x509Certificate = v.getX509Certificate();
                if (x509Certificate == null || !KeyUtil.isCertificateForSignature(x509Certificate)) continue;
                keyAlias = alias;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ProviderUtilException e) {
            throw new RuntimeException(KalkanWrapper.createMessageFromException((Exception)e));
        }
        if (keyAlias == null) {
            throw new RuntimeException("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
        }
        if (aliases.isEmpty()) {
            RuntimeException e = new RuntimeException("Key reading error: Key does not have aliases.");
            BundleLog.LOG.error("Key reading error: Key does not have aliases.", e);
            throw e;
        }
        return new KeyStoreWrapper(store, choosenalias, password, aliases);
    }

    public KeyStoreWrapper read(DocumentSignatureRequest signers) {
        return this.read(signers.getStorageName(), signers.getContainer(), signers.getPassword(), signers.getAlias());
    }

    public static String createMessageFromException(Exception e) {
        String message = e.getMessage();
        if (message != null && message.contains("certificate expired on")) {
            String dateStr = message.replace("certificate expired on", "").trim();
            String[] arr = dateStr.split("GMT");
            return "\u041a\u043b\u044e\u0447 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d " + arr[0].substring(0, 8);
        }
        switch (message) {
            case "Malformed content.": {
                return "\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442";
            }
            case "stream does not represent a PKCS12 key store": {
                return "Key reading error: Invalid format.";
            }
            case "PKCS12 key store mac invalid - wrong password or corrupted file.": {
                return "Key reading error: Password incorrect.";
            }
            case "IOException reading content.": {
                return "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435";
            }
        }
        return message;
    }

    public String getContainer(String storageName) throws CardException, KalkanException, ProviderUtilException {
        List slots = KeyStoreUtil.loadSlotList((Storage)Storage.get((String)storageName));
        if (slots != null && !slots.isEmpty()) {
            return (String)slots.get(0);
        }
        throw new RuntimeException("No container found!");
    }

    public KalkanProvider getKalkanProvider() {
        return this.kalkanProvider;
    }
}

