/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.wrapper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.dto.certificate.CertificateInfo;
import kz.devart.bundle.dto.certificate.CertificateKeyUsage;
import kz.devart.bundle.dto.certificate.CertificateKeyUser;
import kz.devart.bundle.dto.certificate.CertificateRevocationStatus;
import kz.devart.bundle.dto.certificate.CertificateSubject;
import kz.devart.bundle.dto.crl.CrlResult;
import kz.devart.bundle.dto.crl.CrlStatus;
import kz.devart.bundle.dto.ocsp.OcspStatus;
import kz.devart.bundle.util.KalkanUtil;
import kz.devart.bundle.util.Util;
import kz.gov.pki.kalkan.asn1.DERIA5String;
import kz.gov.pki.kalkan.asn1.x509.CRLDistPoint;
import kz.gov.pki.kalkan.asn1.x509.DistributionPoint;
import kz.gov.pki.kalkan.asn1.x509.DistributionPointName;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.asn1.x509.GeneralNames;
import kz.gov.pki.kalkan.x509.extension.X509ExtensionUtil;
import org.bouncycastle.asn1.x509.Extension;

public class CertificateWrapper {
    private final X509Certificate x509Certificate;
    private CertificateWrapper issuerCertificate;
    private List<OcspStatus> ocspStatus;
    private CrlStatus crlStatus;
    private final String[] signAlg;

    public CertificateWrapper(X509Certificate certificate) {
        Objects.requireNonNull(certificate);
        this.x509Certificate = certificate;
        this.signAlg = KalkanUtil.getSignMethodByOID(this.x509Certificate.getSigAlgOID());
    }

    public String getSignAlgorithmId() {
        return this.signAlg[0];
    }

    public String getHashAlgorithmId() {
        return this.signAlg[1];
    }

    public CertificateInfo toCertificateInfo(Date date, boolean checkOcsp, boolean checkCrl) {
        X509Certificate cert = this.getX509Certificate();
        ArrayList<CertificateRevocationStatus> revocations = new ArrayList<CertificateRevocationStatus>();
        if (this.crlStatus != null) {
            revocations.add(this.crlStatus.toCertificateRevocationStatus());
        }
        if (this.ocspStatus != null) {
            revocations.addAll(this.ocspStatus.stream().map(OcspStatus::toCertificateRevocationStatus).collect(Collectors.toList()));
        }
        return CertificateInfo.builder().valid(this.isValid(date, checkOcsp, checkCrl)).revocations(revocations).notBefore(cert.getNotBefore()).notAfter(cert.getNotAfter()).keyUsage(CertificateKeyUsage.fromKeyUsageBits(cert.getKeyUsage())).serialNumber(cert.getSerialNumber().toString(16)).signAlg(cert.getSigAlgName()).keyUser(this.getKeyUser()).publicKey(new String(Base64.getEncoder().encode(cert.getPublicKey().getEncoded()))).signature(new String(Base64.getEncoder().encode(cert.getSignature()))).subject(CertificateWrapper.createCertificateSubjectFromDn(cert.getSubjectX500Principal().toString()).orElse(null)).issuer(CertificateWrapper.createCertificateSubjectFromDn(cert.getIssuerX500Principal().toString()).orElse(null)).build();
    }

    public List<URL> getCrlList() {
        byte[] crlDistributionPoint = this.getX509Certificate().getExtensionValue(Extension.cRLDistributionPoints.getId());
        CRLDistPoint distPoint = null;
        if (crlDistributionPoint == null) {
            return Collections.emptyList();
        }
        try {
            distPoint = CRLDistPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])crlDistributionPoint));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<String> crls = new ArrayList<String>();
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genNames[j].getName()).getString();
                crls.add(url);
            }
        }
        return crls.stream().map(u -> Util.createNewUrl(u, BundleLog.LOG)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean isValid(Date date, boolean checkOcsp, boolean checkCrl) {
        return this.isDateValid(date) && this.issuerCertificate != null && this.issuerCertificate.isDateValid(date) && (!checkOcsp || this.ocspStatus != null && this.ocspStatus.stream().allMatch(OcspStatus::isActive)) && (!checkCrl || this.crlStatus != null && this.crlStatus.getResult().equals((Object)CrlResult.ACTIVE));
    }

    public boolean isDateValid() {
        return this.isDateValid(new Date());
    }

    public boolean isDateValid(Date date) {
        return date.after(this.x509Certificate.getNotBefore()) && date.before(this.x509Certificate.getNotAfter());
    }

    public X500Principal getIssuerX500Principal() {
        return this.x509Certificate.getIssuerX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        return this.x509Certificate.getSubjectX500Principal();
    }

    public boolean verify(PublicKey key) {
        try {
            this.x509Certificate.verify(key);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            return false;
        }
    }

    public PublicKey getPublicKey() {
        return this.x509Certificate.getPublicKey();
    }

    private Set<CertificateKeyUser> getKeyUser() {
        try {
            return this.getX509Certificate().getExtendedKeyUsage().stream().map(CertificateKeyUser::fromOID).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        catch (CertificateParsingException e) {
            BundleLog.LOG.error("Certificate key user extracting error", e);
            return Collections.emptySet();
        }
    }

    public static Optional<CertificateWrapper> fromBase64(String encodedCert) {
        return CertificateWrapper.fromBytes(Base64.getDecoder().decode(encodedCert.replaceAll("\\s", "")));
    }

    public static Optional<CertificateWrapper> fromBytes(byte[] encodedCert) {
        Optional<CertificateWrapper> optional;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encodedCert);
        try {
            optional = CertificateWrapper.fromInputStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        inputStream.close();
        return optional;
    }

    public static Optional<CertificateWrapper> fromInputStream(InputStream inputStream) {
        try {
            return Optional.of(new CertificateWrapper((X509Certificate)CertificateFactory.getInstance("X.509", "KALKAN").generateCertificate(inputStream)));
        }
        catch (NoSuchProviderException | CertificateException e) {
            return Optional.empty();
        }
    }

    public static Optional<CertificateWrapper> fromFile(File file) {
        try {
            return CertificateWrapper.fromInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    private static Optional<CertificateSubject> createCertificateSubjectFromDn(String dn) {
        try {
            LdapName ldapName = new LdapName(dn);
            CertificateSubject.CertificateSubjectBuilder subjectBuilder = CertificateSubject.builder();
            for (Rdn rdn : ldapName.getRdns()) {
                if (rdn.getType().equalsIgnoreCase("CN")) {
                    subjectBuilder.commonName((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("SURNAME")) {
                    subjectBuilder.surName((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("SERIALNUMBER")) {
                    String sn = (String)rdn.getValue();
                    if (sn.startsWith("BIN")) {
                        subjectBuilder.bin(((String)rdn.getValue()).replaceAll("^BIN", ""));
                        continue;
                    }
                    subjectBuilder.iin(((String)rdn.getValue()).replaceAll("^IIN", ""));
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("C")) {
                    subjectBuilder.country((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("L")) {
                    subjectBuilder.locality((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("S")) {
                    subjectBuilder.state((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("E")) {
                    subjectBuilder.email((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("O")) {
                    subjectBuilder.organization((String)rdn.getValue());
                    continue;
                }
                if (rdn.getType().equalsIgnoreCase("OU")) {
                    subjectBuilder.bin(((String)rdn.getValue()).replaceAll("^BIN", ""));
                    continue;
                }
                if (!rdn.getType().equalsIgnoreCase("G")) continue;
                subjectBuilder.lastName((String)rdn.getValue());
            }
            subjectBuilder.dn(dn);
            return Optional.of(subjectBuilder.build());
        }
        catch (InvalidNameException e) {
            BundleLog.LOG.log(2, "Distinguished name parseing error", e);
            return Optional.empty();
        }
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public CertificateWrapper getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public void setIssuerCertificate(CertificateWrapper issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
    }

    public List<OcspStatus> getOcspStatus() {
        return this.ocspStatus;
    }

    public void setOcspStatus(List<OcspStatus> ocspStatus) {
        this.ocspStatus = ocspStatus;
    }

    public CrlStatus getCrlStatus() {
        return this.crlStatus;
    }

    public void setCrlStatus(CrlStatus crlStatus) {
        this.crlStatus = crlStatus;
    }
}

