/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kz.devart.bundle.common.BundleLog;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import org.slf4j.Logger;

public final class Util {
    public static String sha1(String data) {
        String sha1 = "";
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(data.getBytes(StandardCharsets.UTF_8));
            sha1 = Util.bytesToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return sha1;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static URL createNewUrl(String url, BundleLog log) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            log.log(2, "Cannot parse url " + url, e);
            return null;
        }
    }

    public static Map<String, URL> urlMap(String url, Logger log) {
        if (url != null && url.length() > 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(url.split("\\s+")).map(u -> Util.createNewUrl(u, BundleLog.LOG)).filter(Objects::nonNull).collect(Collectors.toMap(u -> Util.sha1(u.toString()), Function.identity()));
    }

    public static DERObject byteToASN1(byte[] data) throws IOException {
        try (ASN1InputStream in = new ASN1InputStream(data);){
            DERObject dERObject = in.readObject();
            return dERObject;
        }
    }

    public static String getDigestAlgorithmOidBYSignAlgorithmOid(String signOid) {
        if (signOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return CMSSignedDataGenerator.DIGEST_SHA1;
        }
        if (signOid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return CMSSignedDataGenerator.DIGEST_SHA256;
        }
        if (signOid.equals("1.2.398.3.10.1.1.2.3.1")) {
            return CMSSignedDataGenerator.DIGEST_GOST3411_2015_256;
        }
        if (signOid.equals("1.2.398.3.10.1.1.2.3.2")) {
            return CMSSignedDataGenerator.DIGEST_GOST3411_2015_512;
        }
        return CMSSignedDataGenerator.DIGEST_GOST34311_95;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

