/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kz.devart.bundle.dto.tsp.TsaPolicy;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.verifier.Verifier;
import kz.gov.pki.provider.utils.verifier.VerifierResult;
import kz.gov.pki.provider.utils.verifier.VerifierResultCode;

public final class KeyUtil {
    public static Set<String> NCA_SERIALS = new HashSet<String>();
    private static final Set<String> SIGNATURE_ALGORITHM_IDS;

    public static List<String> getAliases(KeyStore key) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<String> aliases = key.aliases();
            while (aliases.hasMoreElements()) {
                list.add(aliases.nextElement());
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return list;
    }

    public static TsaPolicy getTsaPolicyByCertAlg(X509Certificate certificate) {
        if (certificate.getSigAlgName() != null && certificate.getSigAlgOID().contains("1.2.840.113549.1.1.11")) {
            return TsaPolicy.TSA_RSA_POLICY;
        }
        if (certificate.getSigAlgName() != null && certificate.getSigAlgOID().contains("1.2.398.3.10.1.1.1.2")) {
            return TsaPolicy.TSA_GOST_POLICY;
        }
        if (certificate.getSigAlgName() != null && certificate.getSigAlgOID().contains("1.2.398.3.10.1.1.2.3")) {
            return TsaPolicy.TSA_GOST2015_POLICY;
        }
        return TsaPolicy.TSA_GOSTGT_POLICY;
    }

    public static boolean validateSignatureAlgorithmId(String signatureAlgorithmId) {
        return SIGNATURE_ALGORITHM_IDS.contains(signatureAlgorithmId);
    }

    public static boolean isCertificateForSignature(X509Certificate certificate) throws RuntimeException {
        try {
            VerifierResult verifierResult = Verifier.verifyKNCACertificateTypeSignature((X509Certificate)certificate, null);
            return !VerifierResultCode.X509CERTIFICATE_TYPE_SIGNATURE_FAIL.equals((Object)verifierResult.getCode());
        }
        catch (IOException | CertificateParsingException | ProviderUtilException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<X509Certificate> getDefaultCACerts() throws KeyStoreException, NoSuchProviderException, CertificateException, IOException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        ArrayList<X509Certificate> caCerts = new ArrayList<X509Certificate>();
        KeyStore keyStore = KeyStore.getInstance("JKS", "KALKAN");
        keyStore.load(KeyUtil.class.getResourceAsStream("/truststore_cacerts.jks"), "123456".toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            caCerts.add((X509Certificate)keyStore.getCertificate(aliases.nextElement()));
        }
        result.addAll(Collections.unmodifiableList(caCerts));
        return result;
    }

    public static X509Certificate getNCACertificate(X509Certificate cert) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        X509Certificate caCert = null;
        String algOID = cert.getSigAlgOID();
        for (X509Certificate ca : KeyUtil.getDefaultCACerts()) {
            if (!ca.getSigAlgOID().equalsIgnoreCase(algOID) || !NCA_SERIALS.contains(ca.getSerialNumber().toString(16))) continue;
            caCert = ca;
            break;
        }
        return caCert;
    }

    private KeyUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NCA_SERIALS.add("3576f5b31b5a6821a16fefab1212c94d938dc7ee");
        NCA_SERIALS.add("46170a97a64bbaf7643c87d90c0fe24071595a8d");
        NCA_SERIALS.add("7e30be9fc890633f1fff5a3c0cb0c85f4c6d1708");
        SIGNATURE_ALGORITHM_IDS = new HashSet<String>();
        SIGNATURE_ALGORITHM_IDS.add(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId());
        SIGNATURE_ALGORITHM_IDS.add(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
        SIGNATURE_ALGORITHM_IDS.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004.getId());
        SIGNATURE_ALGORITHM_IDS.add(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId());
        SIGNATURE_ALGORITHM_IDS.add(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId());
    }
}

