/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.util.HashMap;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.tsp.TSPAlgorithms;

public final class KalkanUtil {
    public static final String GOST3410_256_2015 = "1.2.398.3.10.1.1.2.3.1";
    public static final String GOST3410_512_2015 = "1.2.398.3.10.1.1.2.3.2";

    public static String[] getSignMethodByOID(String oid) {
        String[] ret = new String[2];
        if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            ret[0] = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha1";
            ret[1] = "http://www.w3.org/2001/04/xmldsig-more#sha1";
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            ret[0] = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            ret[1] = "http://www.w3.org/2001/04/xmlenc#sha256";
        } else if (oid.equals(GOST3410_512_2015)) {
            ret[0] = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34102015-gostr34112015-512";
            ret[1] = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34112015-512";
        } else if (oid.equals(GOST3410_256_2015)) {
            ret[0] = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34102015-gostr34112015-256";
            ret[1] = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34112015-256";
        } else {
            ret[0] = "http://www.w3.org/2001/04/xmldsig-more#gost34310-gost34311";
            ret[1] = "http://www.w3.org/2001/04/xmldsig-more#gost34311";
        }
        return ret;
    }

    public static String getDigestAlgorithmOidBYSignAlgorithmOid(String signOid) {
        if (signOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return CMSSignedDataGenerator.DIGEST_SHA1;
        }
        if (signOid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return CMSSignedDataGenerator.DIGEST_SHA256;
        }
        return CMSSignedDataGenerator.DIGEST_GOST34311_95;
    }

    public static String getTspHashAlgorithmByOid(String signOid) {
        if (signOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            return TSPAlgorithms.SHA1;
        }
        if (signOid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            return TSPAlgorithms.SHA256;
        }
        return TSPAlgorithms.GOST34311;
    }

    public static String getHashingAlgorithmByOID(String oid) {
        HashMap<String, String> algos = new HashMap<String, String>();
        algos.put(TSPAlgorithms.MD5, "MD5");
        algos.put(TSPAlgorithms.SHA1, "SHA1");
        algos.put(TSPAlgorithms.SHA224, "SHA224");
        algos.put(TSPAlgorithms.SHA256, "SHA256");
        algos.put(TSPAlgorithms.SHA384, "SHA384");
        algos.put(TSPAlgorithms.SHA512, "SHA512");
        algos.put(TSPAlgorithms.RIPEMD128, "RIPEMD128");
        algos.put(TSPAlgorithms.RIPEMD160, "RIPEMD160");
        algos.put(TSPAlgorithms.RIPEMD256, "RIPEMD256");
        algos.put(TSPAlgorithms.GOST34311GT, "GOST34311GT");
        algos.put(TSPAlgorithms.GOST34311, "GOST34311");
        return (String)algos.get(oid);
    }

    private KalkanUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

