/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.util.ArrayList;
import java.util.List;
import kz.devart.bundle.dto.request.DataDto;
import kz.devart.bundle.dto.request.DocumentSignatureRequest;
import kz.devart.bundle.dto.response.CmsExtractResponse;
import kz.devart.bundle.dto.response.CmsResponse;
import kz.devart.bundle.dto.response.DocumentSignatureResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JsonParserUtil {
    public static List<DataDto> getDataList(String jsonCmsCreateRequest) {
        ArrayList<DataDto> result = new ArrayList<DataDto>();
        JSONObject jsonArgs = new JSONObject(jsonCmsCreateRequest);
        JSONArray dataList = jsonArgs.getJSONArray("dataList");
        for (int i = 0; i < dataList.length(); ++i) {
            JSONObject jsonObject = dataList.getJSONObject(i);
            DataDto dataDto = new DataDto(jsonObject.getString("data"), jsonObject.getString("fileName"), jsonObject.getString("dataType"));
            result.add(dataDto);
        }
        return result;
    }

    public static DocumentSignatureRequest getSignerRequest(String jsonCmsCreateRequest) {
        ArrayList<DataDto> dataDtoList = new ArrayList();
        JSONObject jsonArgs = new JSONObject(jsonCmsCreateRequest);
        if (jsonArgs.has("dataList")) {
            dataDtoList = JsonParserUtil.getDataList(jsonCmsCreateRequest);
        }
        return DocumentSignatureRequest.builder().storageName(jsonArgs.getString("storageName")).certificateKeyUser(jsonArgs.has("certificateKeyUser") ? jsonArgs.getString("certificateKeyUser") : null).checkOcsp(jsonArgs.getBoolean("checkOcsp")).checkCrl(jsonArgs.getBoolean("checkCrl")).dataList(dataDtoList).build();
    }

    public static String getCmsResponseArrayAsJson(List<CmsResponse> cmsResponse) {
        JSONArray resultArray = new JSONArray();
        if (cmsResponse != null && !cmsResponse.isEmpty()) {
            cmsResponse.forEach(c -> {
                JSONObject cmsRespJson = new JSONObject(c);
                cmsRespJson.put("cms", (Object)c.getCms());
                cmsRespJson.put("fileName", (Object)c.getFileName());
                resultArray.put((Object)cmsRespJson);
            });
        }
        return resultArray.toString();
    }

    public static String getExtractFromCmsResponseArrayAsJson(CmsExtractResponse cmsResponse) {
        JSONArray resultArray = new JSONArray();
        if (cmsResponse != null && cmsResponse.getDataDtoList() != null && !cmsResponse.getDataDtoList().isEmpty()) {
            cmsResponse.getDataDtoList().forEach(c -> {
                JSONObject cmsRespJson = new JSONObject(c);
                cmsRespJson.put("data", (Object)c.getData());
                cmsRespJson.put("fileName", (Object)c.getFileName());
                resultArray.put((Object)cmsRespJson);
            });
        }
        return resultArray.toString();
    }

    public static DocumentSignatureRequest getDocumentSignatureRequest(String jsonCmsCreateRequest) {
        List<DataDto> dataList = JsonParserUtil.getDataList(jsonCmsCreateRequest);
        JSONObject jsonObject = new JSONObject(jsonCmsCreateRequest);
        return DocumentSignatureRequest.builder().storageName(jsonObject.getString("storageName")).certificateKeyUser(jsonObject.getString("certificateKeyUser")).checkOcsp(jsonObject.getBoolean("checkOcsp")).checkCrl(jsonObject.getBoolean("checkCrl")).dataList(dataList).build();
    }

    public static String getEsfResponseArrayAsJson(List<DocumentSignatureResponse> cmsResponse) {
        JSONArray resultArray = new JSONArray();
        if (cmsResponse != null && !cmsResponse.isEmpty()) {
            cmsResponse.forEach(c -> {
                JSONObject cmsRespJson = new JSONObject(c);
                cmsRespJson.put("signedData", (Object)c.getSignedData());
                cmsRespJson.put("signature", (Object)c.getSignature());
                cmsRespJson.put("certificate", (Object)c.getCertificate());
                cmsRespJson.put("fileName", (Object)c.getFileName());
                resultArray.put((Object)cmsRespJson);
            });
        }
        return resultArray.toString();
    }

    private JsonParserUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

