/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import javax.security.auth.x500.X500PrivateCredential;
import kz.devart.bundle.dto.response.DocumentSignatureResponse;
import kz.devart.bundle.dto.response.StatusResponse;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.util.io.Streams;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;

public final class EsfSignUtil {
    public static X500PrivateCredential loadCredentialFromStream(Storage storage, String container, String password) {
        try {
            KeyStore keyStore = EsfSignUtil.getKeyStore(storage, container, password.toCharArray());
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                return new X500PrivateCredential((X509Certificate)keyStore.getCertificate(alias), (PrivateKey)keyStore.getKey(alias, password.toCharArray()));
            }
            return null;
        }
        catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    public static DocumentSignatureResponse signatureResponse(String data, X500PrivateCredential credential, String fileName) {
        try {
            String signature = EsfSignUtil.signature(data, credential);
            StatusResponse result = ((DocumentSignatureResponse.DocumentSignatureResponseBuilder)((DocumentSignatureResponse.DocumentSignatureResponseBuilder)((DocumentSignatureResponse.DocumentSignatureResponseBuilder)((DocumentSignatureResponse.DocumentSignatureResponseBuilder)DocumentSignatureResponse.builder().signedData(data)).signature(signature)).certificate(EsfSignUtil.toBase64(credential.getCertificate()))).fileName(fileName)).build();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String signature(String documentBody, X500PrivateCredential credential) throws SignatureException {
        return Base64.getEncoder().encodeToString(EsfSignUtil.sign(documentBody.getBytes(StandardCharsets.UTF_8), credential));
    }

    public static byte[] sign(byte[] data, X500PrivateCredential privateCredential) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(privateCredential.getCertificate().getSigAlgName());
            signature.initSign(privateCredential.getPrivateKey());
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException var3) {
            throw new RuntimeException(var3);
        }
    }

    public static String toBase64(X509Certificate certificate) throws CertificateEncodingException {
        return new String(Base64.getEncoder().encode(certificate.getEncoded()));
    }

    public static KeyStore getKeyStore(Storage storage, String container, char[] password) throws KeyStoreException, ProviderUtilException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(storage.getName());
        try {
            EsfSignUtil.loadKeyStore(storage, container, store, password);
            return store;
        }
        catch (IOException var11) {
            String msg = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.";
            if (var11.getMessage().contains("password")) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, (Throwable)var11);
            }
            if (var11.getCause() instanceof KalkanException) {
                KalkanException ke = (KalkanException)var11.getCause();
                if (ke.getErrorCode().equals(PCSCCode.WRONG_PIN) || ke.getErrorCode().equals(PCSCCode.INVALID_PIN_VALUE)) {
                    Object o;
                    Object sw = ke.get("SW");
                    if (sw != null) {
                        msg = msg + " \u041a\u043e\u0434: " + sw;
                    }
                    if ((o = ke.get("RetryCount")) != null) {
                        Integer retryCount = (Integer)ke.get("RetryCount");
                        throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, retryCount.intValue(), msg, (Throwable)ke);
                    }
                    throw new ProviderUtilException(ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD, -1, msg, (Throwable)ke);
                }
                if (ke.getErrorCode().equals(PCSCCode.BLOCKED_PIN)) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD, "\u041f\u0430\u0440\u043e\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.", (Throwable)ke);
                }
            }
            throw var11;
        }
    }

    private static void loadKeyStore(Storage storage, String container, KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, IOException, CertificateException {
        if (storage.isToken()) {
            keyStore.load(Streams.fromString((String)container), password);
        } else if (container == null) {
            keyStore.load(null);
        } else {
            try (FileInputStream inputStream = new FileInputStream(container);){
                keyStore.load(inputStream, password);
            }
        }
    }

    private EsfSignUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

