/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import kz.devart.bundle.dto.certificate.CertificateInfo;
import kz.devart.bundle.dto.certificate.CertificateKeyUser;
import kz.devart.bundle.service.OCSPVerify;
import kz.devart.bundle.util.KeyUtil;
import kz.devart.bundle.wrapper.CertificateWrapper;

public final class CertificateUtil {
    public static void validateCertificateKeyUser(String certificateKeyUser, CertificateWrapper certificateWrapper, boolean checkOcsp, boolean checkCrl) throws Exception {
        CertificateInfo certificateInfo = certificateWrapper.toCertificateInfo(new Date(), checkOcsp, checkCrl);
        X509Certificate cert = certificateWrapper.getX509Certificate();
        cert.checkValidity();
        if (checkOcsp) {
            X509Certificate ncaCertificate = KeyUtil.getNCACertificate(cert);
            OCSPVerify.verify(cert, ncaCertificate);
        }
        if (certificateKeyUser != null && certificateKeyUser.length() > 0) {
            boolean keyUserFound = false;
            for (String keyUser : certificateKeyUser.split(",")) {
                CertificateKeyUser cku;
                Iterator<CertificateKeyUser> iterator = certificateInfo.getKeyUser().iterator();
                while (iterator.hasNext() && !(keyUserFound = (cku = iterator.next()).getName().equalsIgnoreCase(keyUser))) {
                }
                if (keyUserFound) break;
            }
            if (!keyUserFound) {
                throw new CertificateException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0438\u0437\u043d\u0430\u043a " + certificateKeyUser + " \u0432 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0435!");
            }
        }
    }

    private CertificateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

