/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.util.KalkanUtil;
import kz.devart.bundle.util.Util;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DEREncodableVector;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampRequestGenerator;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.kalkan.tsp.TimeStampTokenInfo;

public class TspService {
    public TimeStampToken create(byte[] data, String hashAlg, String reqPolicy) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlg, "KALKAN");
            md.update(data);
            byte[] hash = md.digest();
            TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
            reqGen.setCertReq(true);
            reqGen.setReqPolicy(reqPolicy);
            TimeStampRequest request = reqGen.generate(hashAlg, hash, this.generateNonce());
            byte[] reqData = request.getEncoded();
            int maxRetries = Math.max(1, 10);
            RuntimeException lastException = null;
            for (int retries = 0; retries < maxRetries; ++retries) {
                try {
                    TimeStampResponse response = this.makeRequest(reqData);
                    response.validate(request);
                    return response.getTimeStampToken();
                }
                catch (RuntimeException e) {
                    BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 TSP. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u2116" + retries + " \u0438\u0437 " + maxRetries, e);
                    lastException = e;
                    continue;
                }
            }
            throw lastException;
        }
        catch (IOException | GeneralSecurityException | TSPException e) {
            BundleLog.LOG.error("TSP creation failure.", e);
            throw new RuntimeException("TSP creation failure", e);
        }
    }

    public Optional<TimeStampTokenInfo> info(CMSSignedData data) {
        try {
            TimeStampToken tspt = new TimeStampToken(data);
            SignerId signerConstraints = tspt.getSID();
            CertStore certs = data.getCertificatesAndCRLs("Collection", "KALKAN");
            Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signerConstraints);
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            if (!certIt.hasNext()) {
                return Optional.empty();
            }
            X509Certificate cert = (X509Certificate)certIt.next();
            tspt.validate(cert, "KALKAN");
            return Optional.of(tspt.getTimeStampInfo());
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CertificateExpiredException | CertificateNotYetValidException | CMSException | TSPException e) {
            BundleLog.LOG.error("TSP verification error.", e);
            return Optional.empty();
        }
    }

    public BigInteger generateNonce() {
        return BigInteger.valueOf(System.currentTimeMillis());
    }

    public SignerInformation addTspToSigner(SignerInformation signer, X509Certificate cert, String useTsaPolicy) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException, IOException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (unsignedAttributes != null) {
            vector = unsignedAttributes.toASN1EncodableVector();
        }
        TimeStampToken tsp = this.create(signer.getSignature(), KalkanUtil.getTspHashAlgorithmByOid(cert.getSigAlgOID()), useTsaPolicy);
        byte[] ts = tsp.getEncoded();
        Attribute signatureTimeStamp = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((DEREncodable)Util.byteToASN1(ts)));
        vector.add((DEREncodable)signatureTimeStamp);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)new AttributeTable((DEREncodableVector)vector));
    }

    private TimeStampResponse makeRequest(byte[] request) throws IOException {
        TimeStampResponse timeStampResponse;
        block18: {
            URL url = new URL("http://tsp.pki.gov.kz/");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/timestamp-query");
            try (OutputStream os = con.getOutputStream();){
                os.write(request, 0, request.length);
            }
            catch (IOException e) {
                throw new RuntimeException("TSP request failure.", e);
            }
            int statusCode = con.getResponseCode();
            if (con.getResponseCode() != 200) {
                RuntimeException error = new RuntimeException(String.format("Invalid TSP response status: %d", statusCode));
                BundleLog.LOG.error("Invalid TSP response status: " + statusCode, error);
                throw error;
            }
            InputStream inputStream = con.getInputStream();
            try {
                byte[] targetArray = new byte[inputStream.available()];
                inputStream.read(targetArray);
                timeStampResponse = new TimeStampResponse(targetArray);
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TSPException e) {
                    throw new RuntimeException("TSP request failure.", e);
                }
            }
            inputStream.close();
        }
        return timeStampResponse;
    }
}

