/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.dto.ocsp.OcspResult;
import kz.devart.bundle.dto.ocsp.OcspStatus;
import kz.devart.bundle.wrapper.CertificateWrapper;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.SingleResp;

public class OcspService {
    private final KalkanProvider kalkanProvider;

    public List<OcspStatus> verify(CertificateWrapper cert, CertificateWrapper issuer) {
        ArrayList<OcspStatus> statuses = new ArrayList<OcspStatus>();
        try {
            byte[] nonce = this.generateOcspNonce();
            OCSPReq request = this.buildOcspRequest(cert.getX509Certificate().getSerialNumber(), issuer.getX509Certificate(), nonce);
            byte[] response = this.makeRequest("http://ocsp.pki.gov.kz/", request.getEncoded());
            statuses.add(this.processOcspResponse(new ByteArrayInputStream(response), nonce));
        }
        catch (Exception e) {
            statuses.add(OcspStatus.builder().result(OcspResult.UNKOWN).url("http://ocsp.pki.gov.kz/").message(e.getMessage()).build());
        }
        return statuses;
    }

    private OCSPReq buildOcspRequest(BigInteger serialNumber, X509Certificate issuer, byte[] nonce) throws OCSPException {
        OCSPReqGenerator ocspReqGenerator = new OCSPReqGenerator();
        CertificateID certId = new CertificateID(CertificateID.HASH_SHA256, issuer, serialNumber, this.kalkanProvider.getName());
        ocspReqGenerator.addRequest(certId);
        Hashtable<DERObjectIdentifier, 1> ext = new Hashtable<DERObjectIdentifier, 1>();
        ext.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(nonce))){});
        ocspReqGenerator.setRequestExtensions(new X509Extensions(ext));
        return ocspReqGenerator.generate();
    }

    public byte[] generateOcspNonce() {
        byte[] nonce = new byte[8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(nonce);
        return nonce;
    }

    private OcspStatus processOcspResponse(InputStream response, byte[] nonce) throws IOException, OCSPException {
        SingleResp[] singleResps;
        SingleResp singleResp;
        Object status;
        OCSPResp resp = new OCSPResp(response);
        if (resp.getStatus() != 0) {
            return OcspStatus.builder().result(OcspResult.UNKOWN).message("Unknown status").build();
        }
        BasicOCSPResp brep = (BasicOCSPResp)resp.getResponseObject();
        byte[] respNonceExt = brep.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
        if (respNonceExt != null) {
            try (ASN1InputStream asn1In = new ASN1InputStream(respNonceExt);){
                DERObject derObj = asn1In.readObject();
                byte[] extV = DEROctetString.getInstance((Object)derObj).getOctets();
                try (Object asn2In = new ASN1InputStream(extV);){
                    derObj = asn2In.readObject();
                }
                if (!Arrays.equals(nonce, DEROctetString.getInstance((Object)derObj).getOctets())) {
                    asn2In = OcspStatus.builder().result(OcspResult.UNKOWN).message("Nonce aren't equals").build();
                    return asn2In;
                }
            }
        }
        if ((status = (singleResp = (singleResps = brep.getResponses())[0]).getCertStatus()) == null) {
            return OcspStatus.builder().result(OcspResult.ACTIVE).message("OK").build();
        }
        if (status instanceof RevokedStatus) {
            int reason;
            RevokedStatus rev = (RevokedStatus)status;
            try {
                reason = rev.getRevocationReason();
            }
            catch (IllegalStateException e) {
                reason = -1;
            }
            return OcspStatus.builder().result(OcspResult.REVOKED).revocationTime(rev.getRevocationTime()).revocationReason(reason).message("OK").build();
        }
        return OcspStatus.builder().result(OcspResult.UNKOWN).message("Unknown status").build();
    }

    private byte[] makeRequest(String urlStr, byte[] request) throws IOException {
        byte[] byArray;
        block18: {
            URL url = new URL(urlStr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            try (OutputStream os = con.getOutputStream();){
                os.write(request, 0, request.length);
            }
            catch (IOException e) {
                throw new RuntimeException("TSP request failure.", e);
            }
            int statusCode = con.getResponseCode();
            if (con.getResponseCode() != 200) {
                RuntimeException error = new RuntimeException(String.format("Invalid TSP response status: %d", statusCode));
                BundleLog.LOG.error("Invalid TSP response status: " + statusCode, error);
                throw error;
            }
            InputStream inputStream = con.getInputStream();
            try {
                byte[] targetArray = new byte[inputStream.available()];
                inputStream.read(targetArray);
                byArray = targetArray;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("OCSP request failure.", e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public OcspService(KalkanProvider kalkanProvider) {
        this.kalkanProvider = kalkanProvider;
    }
}

