/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import kz.devart.bundle.exception.CertificateRevokationException;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.ocsp.BasicOCSPResponse;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.asn1.x509.X509ObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.SingleResp;
import kz.gov.pki.kalkan.ocsp.UnknownStatus;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.kalkan.x509.extension.X509ExtensionUtil;

public class OCSPVerify {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(X509Certificate userCertificate, X509Certificate caCertificate) throws Exception {
        Security.addProvider((Provider)new KalkanProvider());
        byte[] ocspReq = OCSPVerify.getOcspPackage(userCertificate.getSerialNumber(), caCertificate, CertificateID.HASH_SHA1);
        String b64Req = new String(Base64.encode((byte[])ocspReq));
        URL url = new URL("http://ocsp.pki.gov.kz/" + b64Req);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        try {
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            try (OutputStream os = con.getOutputStream();){
                os.write(ocspReq);
            }
            OCSPVerify.makeOcspResponse(con);
        }
        finally {
            con.disconnect();
        }
    }

    private static String getOcspUrlFromCertificate(X509Certificate cert) throws IOException {
        byte[] extensionValue = cert.getExtensionValue(X509Extensions.AuthorityInfoAccess.getId());
        ASN1Sequence asn1Seq = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue);
        Enumeration objects = asn1Seq.getObjects();
        while (objects.hasMoreElements()) {
            ASN1Sequence obj = (ASN1Sequence)objects.nextElement();
            DERObjectIdentifier oid = (DERObjectIdentifier)obj.getObjectAt(0);
            DERTaggedObject location = (DERTaggedObject)obj.getObjectAt(1);
            if (location.getTagNo() != 6) continue;
            DEROctetString uri = (DEROctetString)location.getObject();
            String str = new String(uri.getOctets());
            if (!oid.equals((Object)X509ObjectIdentifiers.id_ad_ocsp)) continue;
            return str;
        }
        return null;
    }

    private static void makeOcspResponse(HttpURLConnection con) throws Exception {
        InputStream in = con.getInputStream();
        OCSPResp response = new OCSPResp(in);
        in.close();
        if (response.getStatus() != 0) {
            throw new OCSPException("\u041d\u0435 \u0443\u0434\u0430\u0447\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0442\u043e\u0437\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u044c. \u0421\u0442\u0430\u0442\u0443\u0441: " + response.getStatus());
        }
        BasicOCSPResp brep = (BasicOCSPResp)response.getResponseObject();
        Boolean isRevocationOk = OCSPVerify.singleOCSPVerify(brep.getEncoded());
        if (!isRevocationOk.booleanValue()) {
            throw new CertificateRevokationException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043e\u0442\u043e\u0437\u0432\u0430\u043d");
        }
    }

    private static byte[] getOcspPackage(BigInteger serialNr, Certificate cacert, String hashAlg) throws Exception {
        OCSPReqGenerator gen = new OCSPReqGenerator();
        CertificateID certId = new CertificateID(hashAlg, (X509Certificate)cacert, serialNr, "KALKAN");
        gen.addRequest(certId);
        gen.setRequestExtensions(OCSPVerify.generateExtensions());
        OCSPReq req = gen.generate();
        return req.getEncoded();
    }

    private static X509Extensions generateExtensions() {
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[8];
        sr.nextBytes(nonce);
        Hashtable<DERObjectIdentifier, X509Extension> exts = new Hashtable<DERObjectIdentifier, X509Extension>();
        X509Extension nonceext = new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(nonce)));
        exts.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, nonceext);
        return new X509Extensions(exts);
    }

    public X509Certificate generateCert(String certFile) throws Exception {
        return (X509Certificate)CertificateFactory.getInstance("X.509", "KALKAN").generateCertificate(new FileInputStream(certFile));
    }

    public static boolean singleOCSPVerify(byte[] ocspResponse) throws Exception {
        SingleResp[] singleResps;
        SingleResp singleResp;
        Object status;
        ASN1Object asn1Object = ASN1Object.fromByteArray((byte[])ocspResponse);
        BasicOCSPResp brep = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)asn1Object));
        byte[] respNonceExt = brep.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
        if (respNonceExt != null) {
            ASN1InputStream asn1In = new ASN1InputStream(respNonceExt);
            DERObject derObj = asn1In.readObject();
            asn1In.close();
            byte[] extV = DEROctetString.getInstance((Object)derObj).getOctets();
            asn1In = new ASN1InputStream(extV);
            derObj = asn1In.readObject();
            asn1In.close();
        }
        if ((status = (singleResp = (singleResps = brep.getResponses())[0]).getCertStatus()) == null) {
            return true;
        }
        if (status instanceof RevokedStatus && ((RevokedStatus)status).hasRevocationReason()) {
            System.out.println("REASON: " + ((RevokedStatus)status).getRevocationReason());
            return false;
        }
        if (status instanceof UnknownStatus) {
            throw new RuntimeException("\u041d\u0435 \u043e\u043f\u043e\u0437\u043d\u0430\u043d\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 OCSP!");
        }
        return false;
    }
}

