/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kz.devart.bundle.dto.request.CmsExtractRequest;
import kz.devart.bundle.dto.request.DataDto;
import kz.devart.bundle.dto.request.DocumentSignatureRequest;
import kz.devart.bundle.dto.response.CmsExtractResponse;
import kz.devart.bundle.dto.response.CmsResponse;
import kz.devart.bundle.dto.tsp.TsaPolicy;
import kz.devart.bundle.service.OCSPVerify;
import kz.devart.bundle.service.TspService;
import kz.devart.bundle.util.KeyUtil;
import kz.devart.bundle.util.Util;
import kz.devart.bundle.wrapper.CertificateWrapper;
import kz.devart.bundle.wrapper.KalkanWrapper;
import kz.devart.bundle.wrapper.KeyStoreWrapper;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.osgi.layer.annotations.NCALayerClass;

@NCALayerClass
public class CmsService {
    private TspService tspService = new TspService();
    private DocumentSignatureRequest signerRequest;

    public List<CmsResponse> createOrAddSigners(DocumentSignatureRequest cmsCreateRequest) {
        if (cmsCreateRequest.getDataList() == null || cmsCreateRequest.getDataList().isEmpty()) {
            throw new RuntimeException("Data argument not specified");
        }
        this.signerRequest = cmsCreateRequest;
        ArrayList<CmsResponse> result = new ArrayList<CmsResponse>();
        cmsCreateRequest.getDataList().forEach(dataDto -> {
            byte[] decodedCms = Base64.getDecoder().decode(dataDto.getData());
            try {
                CMSSignedData cms = new CMSSignedData(decodedCms);
                result.add(this.addSigners(dataDto.getFileName(), cms));
            }
            catch (CMSException e) {
                result.add(this.create(dataDto.getFileName(), decodedCms));
            }
        });
        if (result != null && !result.isEmpty()) {
            result.forEach(r -> this.verify(r.getCms(), this.signerRequest.getCheckOcsp()));
        }
        return result;
    }

    public CmsResponse create(String fileName, byte[] data) {
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            CMSProcessableByteArray cmsData = new CMSProcessableByteArray(data);
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            this.addSignersToCmsGenerator(generator, data, certificates, this.signerRequest);
            CertStore chainStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certificates), "KALKAN");
            generator.addCertificatesAndCRLs(chainStore);
            CMSSignedData signed = generator.generate((CMSProcessable)cmsData, true, "KALKAN");
            TsaPolicy tsaPolicyByCertAlg = KeyUtil.getTsaPolicyByCertAlg((X509Certificate)certificates.get(0));
            String useTsaPolicy = tsaPolicyByCertAlg.getPolicyId();
            SignerInformationStore signerStore = signed.getSignerInfos();
            ArrayList<SignerInformation> signers = new ArrayList<SignerInformation>();
            int i = 0;
            for (Object signer : signerStore.getSigners()) {
                X509Certificate cert = (X509Certificate)certificates.get(i++);
                signers.add(this.tspService.addTspToSigner((SignerInformation)signer, cert, useTsaPolicy));
            }
            signed = CMSSignedData.replaceSigners((CMSSignedData)signed, (SignerInformationStore)new SignerInformationStore(signers));
            return ((CmsResponse.CmsResponseBuilder)((CmsResponse.CmsResponseBuilder)CmsResponse.builder().cms(Base64.getEncoder().encodeToString(signed.getEncoded()))).fileName(fileName)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CmsResponse addSigners(String fileName, CMSSignedData cms) {
        try {
            byte[] decodedData;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                cms.getSignedContent().write((OutputStream)out);
                decodedData = out.toByteArray();
            }
            CMSProcessableByteArray cmsData = new CMSProcessableByteArray(decodedData);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSigners(cms.getSignerInfos());
            List<X509Certificate> certificates = this.getCertificatesFromCmsSignedData(cms);
            this.addSignersToCmsGenerator(generator, decodedData, certificates, this.signerRequest);
            CertStore chainStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certificates.stream().distinct().collect(Collectors.toList())), "KALKAN");
            generator.addCertificatesAndCRLs(chainStore);
            CMSSignedData signed = generator.generate((CMSProcessable)cmsData, true, "KALKAN");
            TsaPolicy tsaPolicyByCertAlg = KeyUtil.getTsaPolicyByCertAlg(certificates.get(0));
            String useTsaPolicy = tsaPolicyByCertAlg.getPolicyId();
            SignerInformationStore signerStore = signed.getSignerInfos();
            ArrayList<SignerInformation> signers = new ArrayList<SignerInformation>();
            int i = 0;
            for (Object signer : signerStore.getSigners()) {
                X509Certificate cert = certificates.get(i++);
                if (!CmsService.hasTimestamp((SignerInformation)signer)) {
                    signers.add(this.tspService.addTspToSigner((SignerInformation)signer, cert, useTsaPolicy));
                    continue;
                }
                signers.add((SignerInformation)signer);
            }
            signed = CMSSignedData.replaceSigners((CMSSignedData)signed, (SignerInformationStore)new SignerInformationStore(signers));
            return ((CmsResponse.CmsResponseBuilder)((CmsResponse.CmsResponseBuilder)CmsResponse.builder().cms(Base64.getEncoder().encodeToString(signed.getEncoded()))).fileName(fileName)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean hasTimestamp(SignerInformation signer) {
        Attribute timeStampTokenAttribute;
        AttributeTable attributes = signer.getUnsignedAttributes();
        return attributes != null && (timeStampTokenAttribute = attributes.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null;
    }

    private static boolean isSignerSameAsPrevious(SignerInformation signer, CMSSignedData cms) {
        boolean isCurrentSignerSameAsPrevious = false;
        for (Object obj : cms.getSignerInfos().getSigners()) {
            SignerInformation prevSignerInfo = (SignerInformation)obj;
            if (!prevSignerInfo.getSID().equals((Object)signer.getSID())) continue;
            isCurrentSignerSameAsPrevious = true;
        }
        return isCurrentSignerSameAsPrevious;
    }

    public CmsExtractResponse extract(CmsExtractRequest cmsExtractRequest) throws CMSException, IOException {
        ArrayList<DataDto> dataList = new ArrayList<DataDto>();
        if (cmsExtractRequest != null && cmsExtractRequest.getDataList() != null && !cmsExtractRequest.getDataList().isEmpty()) {
            for (DataDto dataDto : cmsExtractRequest.getDataList()) {
                CMSSignedData cms = new CMSSignedData(Base64.getDecoder().decode(dataDto.getData()));
                if (cms.getSignedContent() == null) {
                    throw new RuntimeException("CMS doesn't have signed content");
                }
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    cms.getSignedContent().write((OutputStream)out);
                    dataList.add(new DataDto(Base64.getEncoder().encodeToString(out.toByteArray()), dataDto.getFileName(), dataDto.getDataType()));
                }
            }
        }
        return ((CmsExtractResponse.CmsExtractResponseBuilder)CmsExtractResponse.builder().dataDtoList(dataList)).build();
    }

    public void verify(String signedCms, boolean checkOcsp) {
        try {
            CMSSignedData cms = new CMSSignedData(Base64.getDecoder().decode(signedCms.getBytes(StandardCharsets.UTF_8)));
            CertStore certStore = cms.getCertificatesAndCRLs("Collection", "KALKAN");
            for (SignerInformation signer : cms.getSignerInfos().getSigners()) {
                SignerId signerConstraints = signer.getSID();
                Collection<? extends Certificate> certCollection = certStore.getCertificates((CertSelector)signerConstraints);
                for (X509Certificate x509Certificate : certCollection) {
                    x509Certificate.checkValidity();
                    if (!checkOcsp) continue;
                    X509Certificate ncaCertificate = KeyUtil.getNCACertificate(x509Certificate);
                    OCSPVerify.verify(x509Certificate, ncaCertificate);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(KalkanWrapper.createMessageFromException(e), e);
        }
    }

    private List<X509Certificate> getCertificatesFromCmsSignedData(CMSSignedData cms) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, CertStoreException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        SignerInformationStore signers = cms.getSignerInfos();
        CertStore clientCerts = cms.getCertificatesAndCRLs("Collection", "KALKAN");
        for (Object signerObj : signers.getSigners()) {
            SignerInformation signer = (SignerInformation)signerObj;
            SignerId signerConstraints = signer.getSID();
            Collection<? extends Certificate> certCollection = clientCerts.getCertificates((CertSelector)signerConstraints);
            for (Certificate certificate : certCollection) {
                X509Certificate cert = (X509Certificate)certificate;
                certs.add(cert);
            }
        }
        return certs;
    }

    private void addSignersToCmsGenerator(CMSSignedDataGenerator generator, byte[] decodedData, List<X509Certificate> certificates, DocumentSignatureRequest signerRequest) throws Exception {
        try {
            KalkanWrapper kalkanWrapper = new KalkanWrapper();
            KeyStoreWrapper ks = kalkanWrapper.read(signerRequest);
            CertificateWrapper cert = ks.getCertificate();
            PrivateKey privateKey = ks.getPrivateKey();
            Signature sig = Signature.getInstance(cert.getX509Certificate().getSigAlgName(), (Provider)kalkanWrapper.getKalkanProvider());
            sig.initSign(privateKey);
            sig.update(decodedData);
            generator.addSigner(privateKey, cert.getX509Certificate(), Util.getDigestAlgorithmOidBYSignAlgorithmOid(cert.getX509Certificate().getSigAlgOID()));
            certificates.add(cert.getX509Certificate());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }
}

