/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.gui.types;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Base64;
import java.util.Objects;
import kz.devart.bundle.common.BundleLog;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KeyStoreEntry;

public class AuthKeyInfo {
    private String alias;
    private String keyId;
    private String algorithm;
    private String subjectCn;
    private String subjectDn;
    private String issuerCn;
    private String issuerDn;
    private String serialNumber;
    private String certNotAfter;
    private String certNotBefore;
    private String authorityKeyIdentifier;
    private String pem;
    private String base64Pem;
    private String certificate;

    public AuthKeyInfo(KeyStoreEntry keyStoreEntry, String alias) {
        X509Certificate certificate = keyStoreEntry.getX509Certificate();
        this.alias = alias;
        this.subjectCn = keyStoreEntry.getSubjectCn();
        this.algorithm = keyStoreEntry.getAlgorithm();
        this.issuerCn = keyStoreEntry.getIssuerCn();
        this.serialNumber = keyStoreEntry.getSerialNumber();
        this.certNotAfter = String.valueOf(certificate.getNotAfter().getTime());
        this.certNotBefore = String.valueOf(certificate.getNotBefore().getTime());
        this.subjectDn = X509Util.getSubjectDN((X509Certificate)certificate).toString();
        this.issuerDn = X509Util.getIssuerDN((X509Certificate)certificate).toString();
        try {
            this.keyId = X509Util.getKeyId((X509Certificate)certificate);
            this.authorityKeyIdentifier = Hex.encodeStr((byte[])X509Util.getAuthorityKeyIdentifier((X509Extension)certificate));
        }
        catch (Exception var6) {
            BundleLog.LOG.log(1, var6.getMessage(), var6);
        }
        try {
            this.pem = X509Util.getPem((X509Certificate)keyStoreEntry.getX509Certificate());
            this.base64Pem = new String(Base64.getEncoder().encode(keyStoreEntry.getX509Certificate().getEncoded()));
        }
        catch (IOException | CertificateEncodingException var5) {
            BundleLog.LOG.log(1, var5.getMessage(), var5);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSubjectCn() {
        return this.subjectCn;
    }

    public String getSubjectDn() {
        return this.subjectDn;
    }

    public String getIssuerCn() {
        return this.issuerCn;
    }

    public String getIssuerDn() {
        return this.issuerDn;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertNotAfter() {
        return this.certNotAfter;
    }

    public String getCertNotBefore() {
        return this.certNotBefore;
    }

    public String getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier;
    }

    public String getPem() {
        return this.pem;
    }

    public String getBase64Pem() {
        return this.base64Pem;
    }

    public void setBase64Pem(String base64Pem) {
        this.base64Pem = base64Pem;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setSubjectCn(String subjectCn) {
        this.subjectCn = subjectCn;
    }

    public void setSubjectDn(String subjectDn) {
        this.subjectDn = subjectDn;
    }

    public void setIssuerCn(String issuerCn) {
        this.issuerCn = issuerCn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setCertNotAfter(String certNotAfter) {
        this.certNotAfter = certNotAfter;
    }

    public void setCertNotBefore(String certNotBefore) {
        this.certNotBefore = certNotBefore;
    }

    public void setAuthorityKeyIdentifier(String authorityKeyIdentifier) {
        this.authorityKeyIdentifier = authorityKeyIdentifier;
    }

    public void setPem(String pem) {
        this.pem = pem;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AuthKeyInfo that = (AuthKeyInfo)o;
            return Objects.equals(this.alias, that.alias) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.subjectCn, that.subjectCn) && Objects.equals(this.subjectDn, that.subjectDn) && Objects.equals(this.issuerCn, that.issuerCn) && Objects.equals(this.issuerDn, that.issuerDn) && Objects.equals(this.serialNumber, that.serialNumber) && Objects.equals(this.certNotAfter, that.certNotAfter) && Objects.equals(this.certNotBefore, that.certNotBefore) && Objects.equals(this.authorityKeyIdentifier, that.authorityKeyIdentifier) && Objects.equals(this.pem, that.pem) && Objects.equals(this.base64Pem, that.base64Pem);
        }
        return false;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthKeyInfo;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.keyId, this.algorithm, this.subjectCn, this.subjectDn, this.issuerCn, this.issuerDn, this.serialNumber, this.certNotAfter, this.certNotBefore, this.authorityKeyIdentifier, this.pem);
    }

    public String toString() {
        return "AuthKeyInfo{alias='" + this.alias + '\'' + ", keyId='" + this.keyId + '\'' + ", algorithm='" + this.algorithm + '\'' + ", subjectCn='" + this.subjectCn + '\'' + ", subjectDn='" + this.subjectDn + '\'' + ", issuerCn='" + this.issuerCn + '\'' + ", issuerDn='" + this.issuerDn + '\'' + ", serialNumber='" + this.serialNumber + '\'' + ", certNotAfter='" + this.certNotAfter + '\'' + ", certNotBefore='" + this.certNotBefore + '\'' + ", authorityKeyIdentifier='" + this.authorityKeyIdentifier + '\'' + ", pem='" + this.pem + '\'' + ", base64Pem='" + this.base64Pem + '\'' + ", certificate='" + this.certificate + '\'' + '}';
    }
}

