/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.gui.model;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardException;
import javax.swing.JFrame;
import kz.devart.bundle.applet.MyFileChooserDialog;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.gui.types.ClientException;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;

public class StorageInfo {
    private String alias;
    private String container;
    private char[] password;
    private KeyStore keyStore;
    private Storage storage;
    private List<String> containers;
    private boolean newkey;

    public StorageInfo(String storageName) throws ClientException {
        if (storageName != null && !storageName.trim().isEmpty()) {
            this.storage = Storage.get((String)storageName);
            if (this.storage == null) {
                throw new ClientException("storage.unknown");
            }
            if (this.storage.isToken() && this.getContainers() == null) {
                throw new ClientException("storage.empty");
            }
            if (!this.storage.isToken()) {
                this.container = this.chooseFile();
                this.newkey = true;
                if (this.container == null) {
                    throw new ClientException("action.canceled");
                }
            } else {
                this.container = this.getContainers().get(0);
            }
        } else {
            throw new ClientException("storageName.param.empty");
        }
    }

    public List<String> getContainers() {
        if (this.containers == null && this.storage.isToken()) {
            try {
                for (String slotName : KeyStoreUtil.loadSlotList((Storage)this.storage)) {
                    if (this.containers == null) {
                        this.containers = new ArrayList<String>();
                    }
                    this.containers.add(slotName);
                }
            }
            catch (CardException | KalkanException | ProviderUtilException var3) {
                BundleLog.LOG.error(var3.getMessage(), var3);
            }
        }
        return this.containers;
    }

    private String chooseFile() throws ClientException {
        MyFileChooserDialog fileChooserDialog = new MyFileChooserDialog(new JFrame(), this.storage.equals((Object)Storage.PKCS12) ? "P12" : "ALL", null);
        return fileChooserDialog.getSelectedFilePath();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getContainer() {
        return this.container;
    }

    public char[] getPassword() {
        return this.password;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isNewkey() {
        return this.newkey;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setContainers(List<String> containers) {
        this.containers = containers;
    }

    public void setNewkey(boolean newkey) {
        this.newkey = newkey;
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorageInfo;
    }

    public String toString() {
        return "StorageInfo(alias=" + this.getAlias() + ", container=" + this.getContainer() + ", password=" + Arrays.toString(this.getPassword()) + ", keyStore=" + this.getKeyStore() + ", storage=" + this.getStorage() + ", containers=" + this.getContainers() + ", newkey=" + this.isNewkey() + ")";
    }
}

