/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.common.BundleProvider;
import kz.devart.bundle.gui.GUiConstants;
import kz.devart.bundle.gui.ProgramSettings;
import kz.devart.bundle.gui.model.StorageInfo;
import kz.devart.bundle.gui.types.ClientException;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyStoreEntry;

public class DevartSignerDialog
extends JDialog {
    protected JPanel contentPanel;
    private JPanel keyInfoPanel;
    private JPanel keyListPanel;
    private JLabel mesLabel;
    private JButton showPwdBtn;
    private KeyListEntry selectedItem;
    private StorageInfo storageInfo;
    private KNCACertificateType keyType;
    private JButton refreshKeyListButton;
    private JButton canButton;
    private JButton signButton;
    private JButton cancelButton;
    private JComboBox containerComboBox;
    private JPasswordField passwordField;
    private JLabel refreshLoadingJLabel;
    private JLabel signLoadingJLabel;
    private JList<KeyListEntry> keyList;
    private ImageIcon loadingImage;
    private JLabel keyOwnerText;
    private JLabel periodText;
    private JLabel organizationText;
    private JLabel binText;
    private boolean doSign;
    private Map<String, String> titles;
    private final int windowWidth = 660;
    private final int borderGap = 15;
    private final int eleGap = 5;
    private final int mesPanelH = 60;
    private final int headerH = 60;

    public DevartSignerDialog(StorageInfo sInfo, KNCACertificateType inKeyType, Map<String, String> titles) {
        this.storageInfo = sInfo;
        this.titles = titles;
        this.keyType = inKeyType;
        this.getContentPane().setLayout(new BorderLayout());
        this.initHeader();
        this.fillContentPane();
        this.initFooter();
        this.setDialogProperties();
    }

    private void initHeader() {
        String titleKey = this.titles.containsKey("header") ? this.titles.get("header") : (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION) ? "label.signerDialog.authTitle" : "label.signerDialog.signTitle");
        JPanel header = new JPanel();
        header.setBackground(Color.WHITE);
        header.setPreferredSize(new Dimension(660, 60));
        header.setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)header, "North");
        JPanel titlePanel = new JPanel(new FlowLayout(0, 5, 5));
        titlePanel.setBackground(Color.WHITE);
        header.add((Component)titlePanel, "Center");
        JLabel titleLabel = new JLabel("<html><p>" + ProgramSettings.getInstance().getDictionary(titleKey) + "</p></html>");
        titleLabel.setPreferredSize(new Dimension(630, 45));
        titleLabel.setForeground(Color.BLACK);
        titleLabel.setFont(new Font("Tahoma", 1, 16));
        titlePanel.add(titleLabel);
        JPanel logoPanel = new JPanel(new FlowLayout(2, 5, 5));
        logoPanel.setBackground(Color.WHITE);
        logoPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        ImageIcon logo = new ImageIcon(DevartSignerDialog.class.getClassLoader().getResource("logo.png"));
        JLabel logoLabel = new JLabel(logo);
        logoPanel.add(logoLabel);
        header.add((Component)logoPanel, "East");
    }

    private void fillContentPane() {
        this.contentPanel = new JPanel();
        this.contentPanel.setBackground(Color.WHITE);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setPreferredSize(new Dimension(660, 144));
        this.contentPanel.setLayout(null);
        this.contentPanel.add(this.getRefreshLoadingJLabel());
        this.initKeyListPanel();
        this.addStorageTypeForm();
        this.addContainerTypeForm();
        JLabel warningText = this.getWarningText();
        this.contentPanel.add(warningText);
        KeyListener capsLockListener = this.getCapsLockListener(warningText);
        this.addPasswordForm(capsLockListener);
        this.contentPanel.add(this.getShowPwdBtn(capsLockListener));
        this.addRefreshBtn(capsLockListener);
        this.addCancelBtn(capsLockListener);
    }

    private void addRefreshBtn(KeyListener capsLockListener) {
        this.refreshKeyListButton = this.addButton("button.signerDialog.refreshKeyList", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(226, 100, 207, 35), this.contentPanel);
        this.refreshKeyListButton.addActionListener(a -> {
            if (this.passwordField.getPassword() != null && this.passwordField.getPassword().length != 0) {
                this.blockRefreshPart();
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                executorService.execute(() -> {
                    try {
                        this.storageInfo.setPassword(this.passwordField.getPassword());
                        List<KeyListEntry> keys = this.refreshKeyList();
                        if (keys != null && !keys.isEmpty()) {
                            this.contentPanel.setPreferredSize(new Dimension(this.contentPanel.getPreferredSize().width, 401));
                            this.updateKeyList(keys);
                            this.pack();
                            this.refreshLoadingJLabel.setVisible(false);
                            this.keyListPanel.setVisible(true);
                            this.getRootPane().setDefaultButton(this.signButton);
                        } else {
                            if (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION)) {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage.auth"));
                            } else if (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.SIGNATURE)) {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage.sign"));
                            } else {
                                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyStorage"));
                            }
                            this.keyListPanel.setVisible(false);
                            this.contentPanel.setPreferredSize(new Dimension(this.contentPanel.getPreferredSize().width, 144));
                            this.unblockRefreshPart();
                            this.pack();
                        }
                    }
                    catch (Exception var2) {
                        BundleLog.LOG.log(1, var2.getMessage(), var2);
                        this.unblockRefreshPart();
                        this.setMessage(var2.getMessage());
                    }
                });
                executorService.shutdown();
            } else {
                this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.emptyField"));
            }
        });
        this.refreshKeyListButton.addKeyListener(capsLockListener);
        this.getRootPane().setDefaultButton(this.refreshKeyListButton);
    }

    private void addCancelBtn(KeyListener capsLockListener) {
        this.canButton = this.addButton("button.cancel", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(438, 100, 207, 35), this.contentPanel);
        this.canButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        this.canButton.addKeyListener(capsLockListener);
    }

    private JButton getShowPwdBtn(KeyListener capsLockListener) {
        this.showPwdBtn = new JButton((Icon)new ImageIcon(DevartSignerDialog.class.getClassLoader().getResource("eye_16.png"))){

            @Override
            protected void paintComponent(Graphics g) {
                if (!this.isOpaque() && this.getBackground() != null) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(this.getBackground());
                    g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
                    g2.dispose();
                }
                super.paintComponent(g);
            }

            @Override
            protected void paintBorder(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getForeground());
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                g2.dispose();
            }
        };
        this.showPwdBtn.setOpaque(false);
        this.showPwdBtn.setContentAreaFilled(false);
        this.showPwdBtn.setBorderPainted(false);
        this.showPwdBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        this.showPwdBtn.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        this.showPwdBtn.setFont(new Font("Tahoma", 0, 16));
        this.showPwdBtn.setBounds(600, 59, 45, 20);
        this.showPwdBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DevartSignerDialog.this.showPwdBtn.isEnabled()) {
                    DevartSignerDialog.this.passwordField.setEchoChar('\u0000');
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DevartSignerDialog.this.showPwdBtn.isEnabled()) {
                    DevartSignerDialog.this.passwordField.setEchoChar('*');
                    DevartSignerDialog.this.passwordField.requestFocusInWindow();
                }
            }
        });
        this.showPwdBtn.addKeyListener(capsLockListener);
        return this.showPwdBtn;
    }

    private KeyListener getCapsLockListener(final JLabel warningText) {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    warningText.setText("");
                    if (DevartSignerDialog.this.getToolkit().getLockingKeyState(20)) {
                        warningText.setText(ProgramSettings.getInstance().getDictionary("label.warningMessage.capsLock"));
                    }
                    if (!(e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || DevartSignerDialog.this.getInputContext().getLocale().getLanguage().equals("en"))) {
                        if (!warningText.getText().equals("")) {
                            warningText.setText(warningText.getText() + "; ");
                        }
                        warningText.setText(warningText.getText() + ProgramSettings.getInstance().getDictionary("label.warningMessage.language"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
    }

    private JLabel getWarningText() {
        JLabel warningText = new JLabel("");
        warningText.setFont(new Font("Tahoma", 0, 14));
        warningText.setForeground(Color.RED);
        warningText.setBounds(280, 80, 350, 14);
        return warningText;
    }

    private void addPasswordForm(KeyListener capsLockListener) {
        this.addLabel("label.enterPass", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 61, 250, 14), this.contentPanel);
        this.passwordField = new JPasswordField(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.clearRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(this.getBackground());
                g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                g2.dispose();
                super.paintComponent(g);
            }

            @Override
            protected void paintBorder(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getForeground());
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                g2.dispose();
            }
        };
        this.passwordField.setOpaque(false);
        this.passwordField.setForeground(GUiConstants.LABEL_FOREGROUND_COLOR);
        this.passwordField.setFont(new Font("Tahoma", 0, 14));
        this.passwordField.setColumns(15);
        this.passwordField.setBounds(280, 59, 320, 20);
        this.passwordField.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
        this.passwordField.addKeyListener(capsLockListener);
        this.contentPanel.add(this.passwordField);
        this.passwordField.requestFocusInWindow();
    }

    private void addContainerTypeForm() {
        this.addLabel("label.signerDialog.containerType", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 31, 250, 20), this.contentPanel);
        if (this.storageInfo.getStorage().isToken() && this.storageInfo.getContainers().size() > 1) {
            this.contentPanel.add(this.getContainerComboBox());
        } else {
            JLabel containerTypeText = new JLabel(this.storageInfo.getContainer());
            containerTypeText.setBackground(Color.WHITE);
            containerTypeText.setFont(new Font("Tahoma", 0, 14));
            containerTypeText.setBounds(280, 31, 350, 20);
            this.contentPanel.add(containerTypeText);
        }
    }

    private JComboBox getContainerComboBox() {
        this.containerComboBox = new JComboBox();
        this.containerComboBox.setBackground(Color.WHITE);
        this.containerComboBox.setBounds(280, 31, 320, 20);
        for (String container : this.storageInfo.getContainers()) {
            this.containerComboBox.addItem(container);
        }
        this.containerComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.storageInfo.setContainer((String)this.containerComboBox.getSelectedItem());
            }
        });
        return this.containerComboBox;
    }

    private void addStorageTypeForm() {
        this.addLabel("label.signerDialog.storageType", GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(15, 11, 250, 14), this.contentPanel);
        JLabel storageTypeText = new JLabel(ProgramSettings.getInstance().getDictionary("label.signerDialog.storage." + this.storageInfo.getStorage().getName()));
        storageTypeText.setFont(new Font("Tahoma", 0, 14));
        storageTypeText.setBounds(280, 11, 350, 14);
        this.contentPanel.add(storageTypeText);
    }

    private void setDialogProperties() {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setTitle(ProgramSettings.getInstance().getDictionary(this.titles.containsKey("title") ? this.titles.get("title") : "label.signerDialog"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DevartSignerDialog.this.setVisible(false);
                DevartSignerDialog.this.dispose();
            }
        });
        this.setFrameToScreenCenter();
        this.setResizable(false);
        this.pack();
    }

    public boolean getDoSign() {
        return this.doSign;
    }

    public KeyListEntry getSelectedItem() {
        return this.selectedItem;
    }

    private List<KeyListEntry> refreshKeyList() throws Exception {
        ArrayList<KeyStoreEntry> keys = null;
        try {
            Map checkEntries;
            KNCACertificateType kncaCertificateType;
            KeyStore ks = KeyStoreUtil.getKeyStore((Storage)this.storageInfo.getStorage(), (String)this.storageInfo.getContainer(), (char[])this.storageInfo.getPassword(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
            Map entries = null;
            if (this.keyType == null) {
                kncaCertificateType = KNCACertificateType.SIGNATURE;
                entries = KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType);
                kncaCertificateType = KNCACertificateType.AUTHENTICATION;
            } else {
                kncaCertificateType = this.keyType;
            }
            if (entries != null) {
                entries.putAll(KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType));
            } else {
                entries = KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)kncaCertificateType);
            }
            if (kncaCertificateType == KNCACertificateType.AUTHENTICATION && entries.isEmpty() && !(checkEntries = KeyStoreUtil.getKeyStoreEntries((KeyStore)ks, (char[])this.storageInfo.getPassword(), (KNCACertificateType)KNCACertificateType.SIGNATURE)).isEmpty()) {
                for (String key : checkEntries.keySet()) {
                    KeyStoreEntry keyStoreEntry = (KeyStoreEntry)checkEntries.get(key);
                    if (!"ECGOST3410-2015".equals(keyStoreEntry.getAlgorithm())) continue;
                    entries.put(key, keyStoreEntry);
                }
            }
            if (entries != null && !entries.isEmpty()) {
                keys = new ArrayList<KeyStoreEntry>();
                for (KeyStoreEntry kseKey : entries.values()) {
                    keys.add(new KeyListEntry(kseKey.getKeyId(), kseKey.getAlgorithm(), kseKey.getX509Certificate()));
                }
                keys.sort(new KeyListEntryComparator());
            }
            return keys;
        }
        catch (ProviderUtilException var9) {
            if (var9.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                if (var9.getTryCount() > -1) {
                    throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.incorrectPassWithTryCount") + var9.getTryCount());
                }
                throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.incorrectPass"));
            }
            if (var9.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(ProgramSettings.getInstance().getDictionary("label.errorMessage.blockedPass"));
            }
            throw new ClientException(var9.getMessage());
        }
    }

    private void initFooter() {
        JPanel footer = new JPanel();
        footer.setBackground(Color.WHITE);
        footer.setPreferredSize(new Dimension(660, 75));
        footer.setLayout(null);
        this.getContentPane().add((Component)footer, "South");
        JPanel mesPanel = new JPanel();
        mesPanel.setBorder(new EtchedBorder(1, null, null));
        mesPanel.setBounds(15, 0, 630, 60);
        mesPanel.setLayout(null);
        footer.add(mesPanel);
        this.mesLabel = new JLabel();
        this.mesLabel.setBounds(5, 0, 620, 60);
        this.mesLabel.setForeground(Color.RED);
        this.mesLabel.setFont(new Font("Tahoma", 0, 16));
        mesPanel.add(this.mesLabel);
    }

    private void initKeyListPanel() {
        String labelKey = this.keyType != null && this.keyType.equals((Object)KNCACertificateType.AUTHENTICATION) ? "label.signerDialog.chooseKeyAuth" : (this.keyType != null && this.keyType.equals((Object)KNCACertificateType.SIGNATURE) ? "label.signerDialog.chooseKeySign" : "label.signerDialog.chooseKey");
        this.keyListPanel = new JPanel();
        this.keyListPanel.setBackground(Color.WHITE);
        this.keyListPanel.setBounds(15, 144, 630, 350);
        this.keyListPanel.setLayout(null);
        this.addLabel(labelKey, GUiConstants.LABEL_FOREGROUND_COLOR, new Rectangle(0, 11, 224, 14), this.keyListPanel);
        DefaultListModel listModel = new DefaultListModel();
        this.keyList = new JList(listModel);
        this.keyList.setCellRenderer(new ListCellRenderer<KeyListEntry>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends KeyListEntry> list, KeyListEntry value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(true);
                String binLabel = ProgramSettings.getInstance().getDictionary("label.signerDialog.keyInfo.bin");
                String orgLabel = ProgramSettings.getInstance().getDictionary("label.signerDialog.keyInfo.organization");
                String ownerLabel = ProgramSettings.getInstance().getDictionary("label.signerDialog.keyInfo.keyOwner");
                String periodLabel = ProgramSettings.getInstance().getDictionary("label.signerDialog.keyInfo.period");
                JLabel label = new JLabel("<html><div style='margin-top:5px;margin-bottom:5px;'>" + (Objects.equals(value.getBin(), "N/A") && Objects.equals(value.getOrganization(), "N/A") ? "&nbsp;" + ownerLabel + ": " + value.getSubjectCn() + "<br>&nbsp;" + periodLabel + ": " + value.getPeriod() : "&nbsp;" + binLabel + ": " + value.getBin() + "<br>&nbsp;" + ownerLabel + ": " + value.getSubjectCn() + "<br>&nbsp;" + orgLabel + ": " + value.getOrganization() + "<br>&nbsp;" + periodLabel + ": " + value.getPeriod()) + "</div></html>");
                label.setOpaque(true);
                label.setBackground(isSelected ? Color.decode("#acd5fc") : list.getBackground());
                if (value.isExpired()) {
                    label.setBackground(Color.decode("#E0E0E0"));
                }
                panel.add((Component)label, "Center");
                if (index < list.getModel().getSize() - 1) {
                    JPanel separator = new JPanel(){

                        @Override
                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            g.setColor(Color.decode("#BDBDBD"));
                            g.drawLine(0, 0, this.getWidth(), 0);
                        }
                    };
                    separator.setPreferredSize(new Dimension(panel.getWidth(), 1));
                    panel.add((Component)separator, "South");
                }
                return panel;
            }
        });
        this.keyList.setBackground(Color.WHITE);
        this.keyList.setBounds(0, 29, 630, 200);
        this.keyList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.selectedItem = this.keyList.getSelectedValue();
                if (this.selectedItem == null) {
                    this.signButton.setVisible(false);
                    this.setMessage(ProgramSettings.getInstance().getDictionary("label.message.certificateNotFound"));
                } else if (Boolean.TRUE.equals(this.selectedItem.expired)) {
                    this.signButton.setVisible(false);
                    this.setMessage(ProgramSettings.getInstance().getDictionary("label.errorMessage.expired"));
                } else {
                    this.signButton.setVisible(true);
                    this.setMessage("");
                }
            }
        });
        JScrollPane listScrollPane = new JScrollPane(this.keyList);
        listScrollPane.setBounds(0, 29, 630, 180);
        this.keyListPanel.add(listScrollPane);
        this.signButton = this.addButton(this.titles.containsKey("actionBtn") ? this.titles.get("actionBtn") : "button.signerDialog.sign", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(211, 215, 207, 35), this.keyListPanel);
        this.signButton.addActionListener(a -> {
            if (this.selectedItem != null && !this.selectedItem.isExpired()) {
                this.storageInfo.setAlias(this.selectedItem.getKeyId());
                this.doSign = true;
                this.setVisible(false);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "The selected certificate is expired or not available.", "Invalid Selection", 0);
            }
        });
        this.cancelButton = this.addButton("button.cancel", GUiConstants.BUTTON_BACKGROUND_COLOR, new Rectangle(423, 215, 207, 35), this.keyListPanel);
        this.cancelButton.addActionListener(a -> {
            this.storageInfo.setContainer(null);
            this.doSign = false;
            this.setVisible(false);
            this.dispose();
        });
        this.contentPanel.add(this.keyListPanel);
        this.keyListPanel.setVisible(false);
    }

    private JLabel getRefreshLoadingJLabel() {
        this.refreshLoadingJLabel = new JLabel();
        this.loadingImage = new ImageIcon(DevartSignerDialog.class.getClassLoader().getResource("loading.gif"));
        this.refreshLoadingJLabel.setIcon(this.loadingImage);
        this.refreshLoadingJLabel.setBounds(189, 88, 32, 32);
        this.refreshLoadingJLabel.setVisible(false);
        return this.refreshLoadingJLabel;
    }

    private void addLabel(String key, Color foregroundColor, Rectangle rectangle, JPanel paretnt) {
        JLabel label = key == null ? new JLabel() : new JLabel(ProgramSettings.getInstance().getDictionary(key));
        label.setFont(new Font("Tahoma", 0, 14));
        label.setForeground(foregroundColor);
        label.setBounds(rectangle);
        paretnt.add(label);
    }

    private JLabel addDynamicLabel(Rectangle rectangle, JPanel paretnt) {
        JLabel label = new JLabel();
        label.setFont(new Font("Tahoma", 0, 14));
        label.setForeground(GUiConstants.BLACK_FOREGROUND_COLOR);
        label.setBounds(rectangle);
        paretnt.add(label);
        return label;
    }

    private JButton addButton(String key, Color backgroundColor, Rectangle rectangle, JPanel parent) {
        JButton button = new JButton(ProgramSettings.getInstance().getDictionary(key)){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground());
                g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                g2.setColor(this.getForeground());
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                g2.dispose();
                super.paintComponent(g);
            }
        };
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.setForeground(GUiConstants.BUTTON_FOREGROUND_COLOR);
        button.setFont(new Font("Tahoma", 0, 15));
        button.setBackground(backgroundColor);
        button.setBounds(rectangle);
        button.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        parent.add(button);
        return button;
    }

    private void blockRefreshPart() {
        this.refreshLoadingJLabel.setVisible(true);
        this.passwordField.setEnabled(false);
        this.showPwdBtn.setEnabled(false);
        this.showPwdBtn.setBackground(new Color(180, 180, 180));
        if (this.containerComboBox != null) {
            this.containerComboBox.setEnabled(false);
        }
        this.refreshKeyListButton.setEnabled(false);
        this.refreshKeyListButton.setBackground(new Color(180, 180, 180));
        this.canButton.setEnabled(false);
        this.canButton.setBackground(new Color(180, 180, 180));
        this.contentPanel.repaint();
        this.contentPanel.revalidate();
    }

    private void unblockRefreshPart() {
        this.refreshLoadingJLabel.setVisible(false);
        this.passwordField.setEnabled(true);
        this.showPwdBtn.setEnabled(true);
        this.showPwdBtn.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        if (this.containerComboBox != null) {
            this.containerComboBox.setEnabled(true);
        }
        this.refreshKeyListButton.setEnabled(true);
        this.refreshKeyListButton.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
        this.canButton.setEnabled(true);
        this.canButton.setBackground(GUiConstants.BUTTON_BACKGROUND_COLOR);
    }

    private void updateKeyList(List<KeyListEntry> keys) {
        DefaultListModel listModel = (DefaultListModel)this.keyList.getModel();
        listModel.removeAllElements();
        for (KeyListEntry key : keys) {
            listModel.addElement(key);
        }
        if (!keys.isEmpty()) {
            this.keyList.setSelectedIndex(0);
        }
    }

    protected void setMessage(String message) {
        this.mesLabel.setText("<html><p>" + message + "</p></html>");
    }

    private void setFrameToScreenCenter() {
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getPreferredSize().width / 2, d.height / 2 - (this.getPreferredSize().height + 232) / 2);
    }

    private class KeyListEntry
    extends KeyStoreEntry {
        private String period;
        private String organization;
        private String bin;
        private boolean expired;

        public KeyListEntry(String keyId, String algorithm, X509Certificate x509Certificate) throws CertificateException {
            super(keyId, algorithm, x509Certificate);
            this.expired = false;
            if (x509Certificate != null) {
                this.period = this.parseDateToString(x509Certificate.getNotBefore()) + " - " + this.parseDateToString(x509Certificate.getNotAfter());
                this.organization = X509Util.getRdn((X509Name)X509Util.getSubjectDN((X509Certificate)x509Certificate), (DERObjectIdentifier)X509Name.O, (int)0);
                this.bin = X509Util.getRdn((X509Name)X509Util.getSubjectDN((X509Certificate)x509Certificate), (DERObjectIdentifier)X509Name.OU, (int)0);
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException var6) {
                    this.expired = true;
                }
            }
        }

        public String getPeriod() {
            return this.period;
        }

        public String getOrganization() {
            if (this.organization != null) {
                return this.organization;
            }
            return "N/A";
        }

        public String getBin() {
            if (this.bin != null) {
                return this.bin;
            }
            return "N/A";
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.getX509Certificate() == null) {
                sb.append("\u2014").append("<@>");
                sb.append(this.getKeyId());
            } else {
                if (this.organization != null && this.bin != null) {
                    sb.append("\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e").append(" | ");
                } else {
                    sb.append("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e").append(" | ");
                }
                sb.append(this.getSubjectCn()).append(" | ");
                sb.append(this.period).append(" | ");
                sb.append(this.getKeyId()).append(" | ");
            }
            return sb.toString();
        }

        private String parseDateToString(Date date) {
            if (date == null) {
                return null;
            }
            String pattern = "dd.MM.yyyy (HH:mm)";
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.setTimeZone(TimeZone.getTimeZone("Asia/Almaty"));
            return df.format(date);
        }
    }

    private class KeyListEntryComparator
    implements Comparator<KeyStoreEntry> {
        private KeyListEntryComparator() {
        }

        @Override
        public int compare(KeyStoreEntry o1, KeyStoreEntry o2) {
            if (o1.getX509Certificate() == null && o2.getX509Certificate() == null) {
                return 0;
            }
            if (o1.getX509Certificate() != null && o2.getX509Certificate() == null) {
                return -1;
            }
            return o1.getX509Certificate() == null && o2.getX509Certificate() != null ? 1 : o2.getX509Certificate().getNotBefore().compareTo(o1.getX509Certificate().getNotBefore());
        }
    }
}

