/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.dto.ocsp;

import java.util.Date;
import kz.devart.bundle.dto.certificate.CertificateRevocation;
import kz.devart.bundle.dto.certificate.CertificateRevocationStatus;
import kz.devart.bundle.dto.ocsp.OcspResult;

public class OcspStatus {
    private OcspResult result;
    private Date revocationTime;
    private int revocationReason;
    private String message;
    private String url;

    public boolean isActive() {
        return this.getResult().equals((Object)OcspResult.ACTIVE);
    }

    public CertificateRevocationStatus toCertificateRevocationStatus() {
        return CertificateRevocationStatus.builder().revoked(this.result.equals((Object)OcspResult.REVOKED)).revocationTime(this.revocationTime).by(CertificateRevocation.OCSP).reason(this.message).build();
    }

    OcspStatus(OcspResult result, Date revocationTime, int revocationReason, String message, String url) {
        this.result = result;
        this.revocationTime = revocationTime;
        this.revocationReason = revocationReason;
        this.message = message;
        this.url = url;
    }

    public static OcspStatusBuilder builder() {
        return new OcspStatusBuilder();
    }

    public OcspResult getResult() {
        return this.result;
    }

    public Date getRevocationTime() {
        return this.revocationTime;
    }

    public int getRevocationReason() {
        return this.revocationReason;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public void setResult(OcspResult result) {
        this.result = result;
    }

    public void setRevocationTime(Date revocationTime) {
        this.revocationTime = revocationTime;
    }

    public void setRevocationReason(int revocationReason) {
        this.revocationReason = revocationReason;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OcspStatus)) {
            return false;
        }
        OcspStatus other = (OcspStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRevocationReason() != other.getRevocationReason()) {
            return false;
        }
        OcspResult this$result = this.getResult();
        OcspResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        Date this$revocationTime = this.getRevocationTime();
        Date other$revocationTime = other.getRevocationTime();
        if (this$revocationTime == null ? other$revocationTime != null : !((Object)this$revocationTime).equals(other$revocationTime)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OcspStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRevocationReason();
        OcspResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        Date $revocationTime = this.getRevocationTime();
        result = result * 59 + ($revocationTime == null ? 43 : ((Object)$revocationTime).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "OcspStatus(result=" + (Object)((Object)this.getResult()) + ", revocationTime=" + this.getRevocationTime() + ", revocationReason=" + this.getRevocationReason() + ", message=" + this.getMessage() + ", url=" + this.getUrl() + ")";
    }

    public static class OcspStatusBuilder {
        private OcspResult result;
        private Date revocationTime;
        private int revocationReason;
        private String message;
        private String url;

        OcspStatusBuilder() {
        }

        public OcspStatusBuilder result(OcspResult result) {
            this.result = result;
            return this;
        }

        public OcspStatusBuilder revocationTime(Date revocationTime) {
            this.revocationTime = revocationTime;
            return this;
        }

        public OcspStatusBuilder revocationReason(int revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        public OcspStatusBuilder message(String message) {
            this.message = message;
            return this;
        }

        public OcspStatusBuilder url(String url) {
            this.url = url;
            return this;
        }

        public OcspStatus build() {
            return new OcspStatus(this.result, this.revocationTime, this.revocationReason, this.message, this.url);
        }

        public String toString() {
            return "OcspStatus.OcspStatusBuilder(result=" + (Object)((Object)this.result) + ", revocationTime=" + this.revocationTime + ", revocationReason=" + this.revocationReason + ", message=" + this.message + ", url=" + this.url + ")";
        }
    }
}

