/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.dto.crl;

import java.util.Date;
import kz.devart.bundle.dto.certificate.CertificateRevocation;
import kz.devart.bundle.dto.certificate.CertificateRevocationStatus;
import kz.devart.bundle.dto.crl.CrlResult;

public class CrlStatus {
    private final CrlResult result;
    private final String file;
    private final Date revocationDate;
    private final String reason;

    public CertificateRevocationStatus toCertificateRevocationStatus() {
        return CertificateRevocationStatus.builder().revoked(this.result.equals((Object)CrlResult.REVOKED)).revocationTime(this.revocationDate).by(CertificateRevocation.CRL).reason(this.reason).build();
    }

    CrlStatus(CrlResult result, String file, Date revocationDate, String reason) {
        this.result = result;
        this.file = file;
        this.revocationDate = revocationDate;
        this.reason = reason;
    }

    public static CrlStatusBuilder builder() {
        return new CrlStatusBuilder();
    }

    public CrlResult getResult() {
        return this.result;
    }

    public String getFile() {
        return this.file;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrlStatus)) {
            return false;
        }
        CrlStatus other = (CrlStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CrlResult this$result = this.getResult();
        CrlResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        Date this$revocationDate = this.getRevocationDate();
        Date other$revocationDate = other.getRevocationDate();
        if (this$revocationDate == null ? other$revocationDate != null : !((Object)this$revocationDate).equals(other$revocationDate)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CrlStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CrlResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        Date $revocationDate = this.getRevocationDate();
        result = result * 59 + ($revocationDate == null ? 43 : ((Object)$revocationDate).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    public String toString() {
        return "CrlStatus(result=" + (Object)((Object)this.getResult()) + ", file=" + this.getFile() + ", revocationDate=" + this.getRevocationDate() + ", reason=" + this.getReason() + ")";
    }

    public static class CrlStatusBuilder {
        private CrlResult result;
        private String file;
        private Date revocationDate;
        private String reason;

        CrlStatusBuilder() {
        }

        public CrlStatusBuilder result(CrlResult result) {
            this.result = result;
            return this;
        }

        public CrlStatusBuilder file(String file) {
            this.file = file;
            return this;
        }

        public CrlStatusBuilder revocationDate(Date revocationDate) {
            this.revocationDate = revocationDate;
            return this;
        }

        public CrlStatusBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public CrlStatus build() {
            return new CrlStatus(this.result, this.file, this.revocationDate, this.reason);
        }

        public String toString() {
            return "CrlStatus.CrlStatusBuilder(result=" + (Object)((Object)this.result) + ", file=" + this.file + ", revocationDate=" + this.revocationDate + ", reason=" + this.reason + ")";
        }
    }
}

