/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.dto.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kz.devart.bundle.dto.certificate.CertificateInfo;
import kz.devart.bundle.dto.tsp.TspInfo;

public class CmsSignerInfo {
    private List<CertificateInfo> certificates;
    private TspInfo tsp;

    CmsSignerInfo(List<CertificateInfo> certificates, TspInfo tsp) {
        this.certificates = certificates;
        this.tsp = tsp;
    }

    public static CmsSignerInfoBuilder builder() {
        return new CmsSignerInfoBuilder();
    }

    public List<CertificateInfo> getCertificates() {
        return this.certificates;
    }

    public TspInfo getTsp() {
        return this.tsp;
    }

    public void setCertificates(List<CertificateInfo> certificates) {
        this.certificates = certificates;
    }

    public void setTsp(TspInfo tsp) {
        this.tsp = tsp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CmsSignerInfo)) {
            return false;
        }
        CmsSignerInfo other = (CmsSignerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CertificateInfo> this$certificates = this.getCertificates();
        List<CertificateInfo> other$certificates = other.getCertificates();
        if (this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates)) {
            return false;
        }
        TspInfo this$tsp = this.getTsp();
        TspInfo other$tsp = other.getTsp();
        return !(this$tsp == null ? other$tsp != null : !((Object)this$tsp).equals(other$tsp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CmsSignerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CertificateInfo> $certificates = this.getCertificates();
        result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
        TspInfo $tsp = this.getTsp();
        result = result * 59 + ($tsp == null ? 43 : ((Object)$tsp).hashCode());
        return result;
    }

    public String toString() {
        return "CmsSignerInfo(certificates=" + this.getCertificates() + ", tsp=" + this.getTsp() + ")";
    }

    public static class CmsSignerInfoBuilder {
        private ArrayList<CertificateInfo> certificates;
        private TspInfo tsp;

        CmsSignerInfoBuilder() {
        }

        public CmsSignerInfoBuilder certificate(CertificateInfo certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        public CmsSignerInfoBuilder certificates(Collection<? extends CertificateInfo> certificates) {
            if (certificates == null) {
                throw new NullPointerException("certificates cannot be null");
            }
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        public CmsSignerInfoBuilder clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        public CmsSignerInfoBuilder tsp(TspInfo tsp) {
            this.tsp = tsp;
            return this;
        }

        public CmsSignerInfo build() {
            List<CertificateInfo> certificates;
            switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0: {
                    certificates = Collections.emptyList();
                    break;
                }
                case 1: {
                    certificates = Collections.singletonList(this.certificates.get(0));
                    break;
                }
                default: {
                    certificates = Collections.unmodifiableList(new ArrayList<CertificateInfo>(this.certificates));
                }
            }
            return new CmsSignerInfo(certificates, this.tsp);
        }

        public String toString() {
            return "CmsSignerInfo.CmsSignerInfoBuilder(certificates=" + this.certificates + ", tsp=" + this.tsp + ")";
        }
    }
}

