/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.applet;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import kz.devart.bundle.applet.MyFileChooser;

public class MyFileChooserDialog
extends JDialog {
    private String selectedFilePath = null;
    private MyFileChooser fileChooser = null;

    public MyFileChooserDialog(final JFrame owner, String fileExtension, String currentDirectory) {
        super(owner, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u042d\u0426\u041f \u043a\u043b\u044e\u0447\u0430", true);
        this.setAlwaysOnTop(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = screenSize.height;
        int width = screenSize.width;
        this.setSize(width / 2, height / 2);
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(null);
        this.fileChooser = new MyFileChooser(fileExtension);
        if (currentDirectory != null && !currentDirectory.isEmpty()) {
            this.fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        this.fileChooser.setDialogType(0);
        this.add(this.fileChooser);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MyFileChooserDialog.this.dispose();
            }
        });
        this.pack();
        this.fileChooser.revalidate();
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser choser = (JFileChooser)e.getSource();
                String str = e.getActionCommand();
                if (str.equals("ApproveSelection")) {
                    File selectedFile = choser.getSelectedFile();
                    if (selectedFile.exists()) {
                        MyFileChooserDialog.this.setSelectedFilePath(selectedFile.getPath());
                    }
                } else if (str.equals("CancelSelection")) {
                    MyFileChooserDialog.this.setSelectedFilePath(null);
                }
                MyFileChooserDialog.this.setVisible(false);
                if (owner != null) {
                    owner.dispose();
                }
                MyFileChooserDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }
}

