/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle.applet;

import javax.swing.JFileChooser;
import javax.swing.UIManager;
import kz.devart.bundle.applet.MyFileChooserFilter;

public final class MyFileChooser
extends JFileChooser {
    private FileType currentFileType;
    private MyFileChooserFilter keyFilter = new MyFileChooserFilter();

    public MyFileChooser(FileType fileType) {
        this.setFileType(fileType);
        this.setFileFilter(this.keyFilter);
        if (String.valueOf((Object)fileType).equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateLanguage();
    }

    public MyFileChooser(String fileType) {
        if (fileType != null && !fileType.isEmpty()) {
            this.setFileType(FileType.valueOf(fileType));
        } else {
            this.setFileType(FileType.DIRECTORY);
        }
        this.setFileFilter(this.keyFilter);
        if (fileType.equalsIgnoreCase("ALL")) {
            this.removeChoosableFileFilter(this.getFileFilter());
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        this.updateLanguage();
    }

    public void setFileType(FileType fileType) {
        this.currentFileType = fileType;
        this.keyFilter.clearExtension();
        switch (fileType) {
            case DIRECTORY: {
                this.keyFilter.addExtension("");
                this.keyFilter.setDescription("\u041f\u0430\u043f\u043a\u0430");
                this.setFileSelectionMode(1);
                break;
            }
            case CER: {
                this.keyFilter.addExtension("der");
                this.keyFilter.addExtension("cer");
                this.keyFilter.setDescription("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442");
                this.setFileSelectionMode(0);
                break;
            }
            case CRL: {
                this.keyFilter.addExtension("crl");
                this.keyFilter.setDescription("crl");
                this.setFileSelectionMode(0);
                break;
            }
            case P12: {
                this.keyFilter.addExtension("p12");
                this.keyFilter.setDescription("\u041a\u043b\u044e\u0447\u044c P12");
                this.setFileSelectionMode(0);
                break;
            }
            case JKS: {
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription("\u041a\u043b\u044e\u0447\u044c jks");
                this.setFileSelectionMode(0);
                break;
            }
            case KEYSTORE: {
                this.keyFilter.addExtension("pfx");
                this.keyFilter.addExtension("p12");
                this.keyFilter.addExtension("bin");
                this.keyFilter.addExtension("jks");
                this.keyFilter.setDescription("\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043a\u043b\u044e\u0447\u0430");
                this.setFileSelectionMode(0);
                break;
            }
            case ALL: {
                this.keyFilter.addExtension("*");
                this.keyFilter.setDescription("\u0424\u0430\u0439\u043b");
                this.setFileSelectionMode(0);
            }
        }
    }

    public void updateLanguage() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.setDialogTitle(" \u041f\u0430\u043f\u043a\u0430");
                break;
            }
            default: {
                this.setDialogTitle(" \u0424\u0430\u0439\u043b");
            }
        }
        UIManager.put("FileChooser.openButtonText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        UIManager.put("FileChooser.saveButtonText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        UIManager.put("FileChooser.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.openButtonToolTipText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        UIManager.put("FileChooser.saveButtonToolTipText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        UIManager.put("FileChooser.cancelButtonToolTipText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.lookInLabelText", "");
        UIManager.put("FileChooser.saveInLabelText", "");
        UIManager.put("FileChooser.fileNameLabelText", "");
        UIManager.put("FileChooser.filesOfTypeLabelText", "");
        UIManager.put("FileChooser.upFolderToolTipText", "");
        UIManager.put("FileChooser.homeFolderToolTipText", "");
        UIManager.put("FileChooser.newFolderToolTipText", "");
        UIManager.put("FileChooser.listViewButtonToolTipText", "");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "");
        UIManager.put("FileChooser.directoryOpenButtonText", "");
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", "");
        this.updateDescription();
        this.updateUI();
    }

    public void updateDescription() {
        switch (this.currentFileType) {
            case DIRECTORY: {
                this.keyFilter.setDescription("");
                break;
            }
            case CER: {
                this.keyFilter.setDescription("");
                break;
            }
            case CRL: {
                this.keyFilter.setDescription("");
                break;
            }
            case P12: {
                this.keyFilter.setDescription("");
                break;
            }
            case JKS: {
                this.keyFilter.setDescription("");
                break;
            }
            case KEYSTORE: {
                this.keyFilter.setDescription("");
                break;
            }
            default: {
                this.keyFilter.setDescription("");
            }
        }
    }

    public static enum FileType {
        DIRECTORY,
        CRL,
        CER,
        P12,
        KEYSTORE,
        JKS,
        ALL;

    }
}

