/*
 * Decompiled with CFR 0.152.
 */
package kz.devart.bundle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500PrivateCredential;
import kz.devart.bundle.common.BundleLog;
import kz.devart.bundle.common.BundleProvider;
import kz.devart.bundle.dto.request.CmsExtractRequest;
import kz.devart.bundle.dto.request.DataDto;
import kz.devart.bundle.dto.request.DataType;
import kz.devart.bundle.dto.request.DocumentSignatureRequest;
import kz.devart.bundle.dto.response.CmsExtractResponse;
import kz.devart.bundle.dto.response.CmsResponse;
import kz.devart.bundle.dto.response.DocumentSignatureResponse;
import kz.devart.bundle.gui.dialog.DevartSignerDialog;
import kz.devart.bundle.gui.model.StorageInfo;
import kz.devart.bundle.gui.types.ClientException;
import kz.devart.bundle.service.CmsService;
import kz.devart.bundle.util.CertificateUtil;
import kz.devart.bundle.util.EsfSignUtil;
import kz.devart.bundle.util.JsonParserUtil;
import kz.devart.bundle.util.XmlSignUtil;
import kz.devart.bundle.wrapper.CertificateWrapper;
import kz.devart.bundle.wrapper.KalkanWrapper;
import kz.devart.bundle.wrapper.KeyStoreWrapper;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.osgi.layer.annotations.NCALayerClass;
import kz.gov.pki.osgi.layer.annotations.NCALayerMethod;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KNCACertificateType;
import org.json.JSONObject;

@NCALayerClass
public class DevartNLClass {
    private static final Map<String, DocumentSignatureRequest> SIGNATURE_REQUEST_MAP = new HashMap<String, DocumentSignatureRequest>();

    @NCALayerMethod
    public String getSignerInfo(String json) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            DocumentSignatureRequest signerRequest = this.initRequest(json);
            String userCertInfo = signerRequest.getUserCertInfo();
            map.put("userCertInfo", userCertInfo);
            String hash = Base64.getEncoder().encodeToString((LocalDateTime.now() + userCertInfo).getBytes(StandardCharsets.UTF_8));
            map.put("token", hash);
            SIGNATURE_REQUEST_MAP.put(hash, signerRequest);
            String errorResponseJson = new JSONObject(map).toString();
            return errorResponseJson;
        }
        catch (RuntimeException | ClientException e) {
            e.printStackTrace();
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NCALayerMethod
    public String signDevart(String json) {
        try {
            BundleLog.LOG.info(json);
            StringBuilder resultJson = new StringBuilder("{ \"signedResult\" : {");
            JSONObject jsonObject = new JSONObject(json);
            String token = jsonObject.getString("token");
            DocumentSignatureRequest signerRequest = SIGNATURE_REQUEST_MAP.get(token);
            ArrayList<DataDto> esfDataDtoList = new ArrayList<DataDto>();
            if (jsonObject.has("dataList")) {
                esfDataDtoList.addAll(JsonParserUtil.getDataList(json));
            }
            String userCertInfo = signerRequest.getUserCertInfo();
            if (jsonObject.has("certificateKeyUser")) {
                signerRequest.setCertificateKeyUser(jsonObject.getString("certificateKeyUser"));
            }
            KalkanWrapper kalkanWrapper = new KalkanWrapper();
            KeyStoreWrapper ks = kalkanWrapper.read(signerRequest);
            CertificateWrapper cert = ks.getCertificate();
            CertificateUtil.validateCertificateKeyUser(signerRequest.getCertificateKeyUser(), cert, signerRequest.getCheckOcsp(), signerRequest.getCheckCrl());
            Set dataTypeSet = esfDataDtoList.stream().map(dataDto -> dataDto.getDataType().toUpperCase()).collect(Collectors.toSet());
            resultJson.append(Arrays.stream(DataType.values()).filter(dataType -> dataTypeSet.contains(dataType.getName())).map(dataType -> {
                StringBuilder tmpSb = new StringBuilder();
                List<DataDto> tmpDataList = esfDataDtoList.stream().filter(d -> d.getDataType().equalsIgnoreCase(dataType.getName())).collect(Collectors.toList());
                if (tmpDataList != null && !tmpDataList.isEmpty()) {
                    signerRequest.setDataList(tmpDataList);
                    tmpSb.append("\"");
                    tmpSb.append(dataType.name());
                    tmpSb.append("\": ");
                    if (dataType.equals((Object)DataType.ESF)) {
                        tmpSb.append(this.signEsfData(signerRequest));
                    } else if (dataType.equals((Object)DataType.XML)) {
                        tmpSb.append(this.signXmlData(signerRequest));
                    } else {
                        tmpSb.append(this.signCms(signerRequest));
                    }
                }
                return tmpSb.toString();
            }).collect(Collectors.joining(", ")));
            resultJson.append("} }");
            return resultJson.toString();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String signCms(DocumentSignatureRequest signerRequest) {
        try {
            CmsService cmsService = new CmsService();
            List<CmsResponse> cmsResponse = cmsService.createOrAddSigners(signerRequest);
            String responseJson = JsonParserUtil.getCmsResponseArrayAsJson(cmsResponse);
            return responseJson;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
    }

    @NCALayerMethod
    public String extractFromCms(String jsonExtractFromCmsRequest) {
        try {
            List<DataDto> dataDtoList = JsonParserUtil.getDataList(jsonExtractFromCmsRequest);
            CmsExtractRequest cmsCreateRequest = new CmsExtractRequest(dataDtoList);
            CmsService cmsService = new CmsService();
            CmsExtractResponse cmsExtractResponses = cmsService.extract(cmsCreateRequest);
            String responseJson = JsonParserUtil.getExtractFromCmsResponseArrayAsJson(cmsExtractResponses);
            return responseJson;
        }
        catch (IOException | CMSException e) {
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            e.printStackTrace();
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + KalkanWrapper.createMessageFromException((Exception)e));
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
    }

    public String signXmlData(DocumentSignatureRequest documentSignatureRequest) {
        ArrayList<DocumentSignatureResponse> documentSignatureResponseList = new ArrayList<DocumentSignatureResponse>();
        try {
            X500PrivateCredential x500PrivateCredential = EsfSignUtil.loadCredentialFromStream(Storage.get((String)documentSignatureRequest.getStorageName()), documentSignatureRequest.getContainer(), documentSignatureRequest.getPassword());
            for (DataDto dataDto : documentSignatureRequest.getDataList()) {
                DocumentSignatureResponse documentSignatureResponse = XmlSignUtil.signatureResponse(new String(Base64.getDecoder().decode(dataDto.getData()), StandardCharsets.UTF_8).replaceAll("\\r", ""), x500PrivateCredential, dataDto.getFileName());
                documentSignatureResponseList.add(documentSignatureResponse);
            }
            String responseJson = JsonParserUtil.getEsfResponseArrayAsJson(documentSignatureResponseList);
            return responseJson;
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            e.printStackTrace();
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
    }

    public String signEsfData(DocumentSignatureRequest documentSignatureRequest) {
        ArrayList<DocumentSignatureResponse> documentSignatureResponseList = new ArrayList<DocumentSignatureResponse>();
        try {
            X500PrivateCredential x500PrivateCredential = EsfSignUtil.loadCredentialFromStream(Storage.get((String)documentSignatureRequest.getStorageName()), documentSignatureRequest.getContainer(), documentSignatureRequest.getPassword());
            for (DataDto dataDto : documentSignatureRequest.getDataList()) {
                DocumentSignatureResponse documentSignatureResponse = EsfSignUtil.signatureResponse(new String(Base64.getDecoder().decode(dataDto.getData()), StandardCharsets.UTF_8).replaceAll("\\r", ""), x500PrivateCredential, dataDto.getFileName());
                documentSignatureResponseList.add(documentSignatureResponse);
            }
            String responseJson = JsonParserUtil.getEsfResponseArrayAsJson(documentSignatureResponseList);
            return responseJson;
        }
        catch (Exception e) {
            BundleLog.LOG.log(1, "\u041e\u0448\u0438\u0431\u043a\u0430!", e);
            e.printStackTrace();
            HashMap<String, String> errorResponseMap = new HashMap<String, String>();
            errorResponseMap.put("errorCode", "\u041e\u0448\u0438\u0431\u043a\u0430! " + e.getMessage());
            String errorResponseJson = new JSONObject(errorResponseMap).toString();
            return errorResponseJson;
        }
    }

    private StorageInfo getStorageInfo(String storageName) throws ClientException {
        StorageInfo storageInfo = new StorageInfo(storageName);
        HashMap<String, String> titles = new HashMap<String, String>();
        titles.put("title", "label.signerDialog.plainDataTitle");
        DevartSignerDialog devartSignerDialog = new DevartSignerDialog(storageInfo, KNCACertificateType.SIGNATURE, titles);
        devartSignerDialog.setVisible(true);
        return storageInfo;
    }

    private DocumentSignatureRequest initRequest(String esfDocumentSignRequest) throws ClientException, KeyStoreException {
        DocumentSignatureRequest documentSignatureRequest = JsonParserUtil.getSignerRequest(esfDocumentSignRequest);
        StorageInfo storageInfo = this.getStorageInfo(documentSignatureRequest.getStorageName());
        if (storageInfo.getContainer() == null || storageInfo.getContainer().length() <= 0) {
            throw new RuntimeException("\u041d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438!");
        }
        documentSignatureRequest.setContainer(storageInfo.getContainer());
        System.out.println("Container: " + storageInfo.getContainer());
        if (documentSignatureRequest.getContainer() != null && storageInfo.getContainer().length() > 0 && storageInfo.getPassword() != null && storageInfo.getPassword().length > 0) {
            documentSignatureRequest.setPassword(new String(storageInfo.getPassword()));
            try {
                KeyStore keyStore = KeyStoreUtil.getKeyStore((Storage)Storage.get((String)documentSignatureRequest.getStorageName()), (String)documentSignatureRequest.getContainer(), (char[])documentSignatureRequest.getPassword().toCharArray(), (Provider)BundleProvider.KALKANCRYPT.getProvider());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(keyStore.getCertificate(storageInfo.getAlias()).getEncoded()));
                documentSignatureRequest.setAlias(new String(storageInfo.getAlias()));
                documentSignatureRequest.setUserCertInfo(x509Certificate.getSubjectDN().toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return documentSignatureRequest;
        }
        throw new RuntimeException("\u041d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438!");
    }
}

